/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.mssqlclient.data;

import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.tests.mssqlclient.data.MSSQLDataTypeTestBase;
import java.time.LocalTime;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class MSSQLTimeDataTypeTest
extends MSSQLDataTypeTestBase {
    private static final int[] HUNDRED_NANOS = new int[]{0, 1000000, 1100000, 1110000, 1111000, 1111100, 1111110, 1111111};

    @Test
    public void testQueryTime(TestContext ctx) {
        LocalTime localTime = LocalTime.of(8, 33, 21, 100 * HUNDRED_NANOS[7]);
        String value = String.format("'%s'", localTime);
        for (int i = 0; i <= 7; ++i) {
            String columnName = String.format("test_time_%d", i);
            String type = String.format("TIME(%d)", i);
            LocalTime expected = localTime.withNano(100 * HUNDRED_NANOS[i]);
            this.testQueryDecodeGenericWithoutTable(ctx, columnName, type, value, expected);
        }
    }

    @Test
    public void testPreparedQueryTime(TestContext ctx) {
        LocalTime localTime = LocalTime.of(8, 33, 21, 100 * HUNDRED_NANOS[7]);
        String value = String.format("'%s'", localTime);
        for (int i = 0; i <= 7; ++i) {
            String columnName = String.format("test_time_%d", i);
            String type = String.format("TIME(%d)", i);
            LocalTime expected = localTime.withNano(100 * HUNDRED_NANOS[i]);
            this.testPreparedQueryDecodeGenericWithoutTable(ctx, columnName, type, value, expected);
        }
    }
}

