/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.mssqlclient.data;

import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.tests.mssqlclient.data.MSSQLDataTypeTestBase;
import java.math.BigDecimal;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class MSSQLSmallMoneyDataTypeTest
extends MSSQLDataTypeTestBase {
    @Test
    public void testQueryLargeMoney(TestContext ctx) {
        this.testQueryDecodeGenericWithoutTable(ctx, "test_smallmoney", "SMALLMONEY", "214748.36", new BigDecimal("214748.36"));
    }

    @Test
    public void testQueryLargeNegativeMoney(TestContext ctx) {
        this.testQueryDecodeGenericWithoutTable(ctx, "test_smallmoney", "SMALLMONEY", "-214748.36", new BigDecimal("-214748.36"));
    }

    @Test
    public void testQueryMoneyWithCurrency(TestContext ctx) {
        this.testQueryDecodeGenericWithoutTable(ctx, "test_smallmoney", "SMALLMONEY", "$12.34", new BigDecimal("12.34"));
    }

    @Test
    public void testPreparedQueryLargeMoney(TestContext ctx) {
        this.testPreparedQueryDecodeGenericWithoutTable(ctx, "test_smallmoney", "SMALLMONEY", "214748.36", new BigDecimal("214748.36"));
    }

    @Test
    public void testPreparedQueryLargeNegativeMoney(TestContext ctx) {
        this.testPreparedQueryDecodeGenericWithoutTable(ctx, "test_smallmoney", "SMALLMONEY", "-214748.36", new BigDecimal("-214748.36"));
    }

    @Test
    public void testPreparedQueryMoneyWithCurrency(TestContext ctx) {
        this.testPreparedQueryDecodeGenericWithoutTable(ctx, "test_smallmoney", "SMALLMONEY", "$12.34", new BigDecimal("12.34"));
    }
}

