/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.mssqlclient.data;

import io.vertx.core.buffer.Buffer;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.data.NullValue;
import io.vertx.tests.mssqlclient.data.MSSQLNullableDataTypeTestBase;
import io.vertx.tests.sqlclient.ColumnChecker;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class MSSQLPreparedQueryNullableDataTypeTest
extends MSSQLNullableDataTypeTestBase {
    @Test
    public void testEncodeTinyInt(TestContext ctx) {
        this.testEncodeNumber(ctx, "test_tinyint", (short)255);
    }

    @Test
    public void testEncodeNullTinyInt(TestContext ctx) {
        this.testPreparedQueryEncodeGeneric(ctx, "nullable_datatype", "test_tinyint", SHORT_NULL_VALUE, row -> ColumnChecker.checkColumn((int)0, (String)"test_tinyint").returnsNull().forRow(row));
    }

    @Test
    public void testEncodeSmallInt(TestContext ctx) {
        this.testEncodeNumber(ctx, "test_smallint", (short)Short.MIN_VALUE);
    }

    @Test
    public void testEncodeNullSmallInt(TestContext ctx) {
        this.testPreparedQueryEncodeGeneric(ctx, "nullable_datatype", "test_smallint", SHORT_NULL_VALUE, row -> ColumnChecker.checkColumn((int)0, (String)"test_smallint").returnsNull().forRow(row));
    }

    @Test
    public void testEncodeInt(TestContext ctx) {
        this.testEncodeNumber(ctx, "test_int", Integer.MIN_VALUE);
    }

    @Test
    public void testEncodeNullInt(TestContext ctx) {
        this.testPreparedQueryEncodeGeneric(ctx, "nullable_datatype", "test_int", INT_NULL_VALUE, row -> ColumnChecker.checkColumn((int)0, (String)"test_int").returnsNull().forRow(row));
    }

    @Test
    public void testEncodeBigInt(TestContext ctx) {
        this.testEncodeNumber(ctx, "test_bigint", Long.MIN_VALUE);
    }

    @Test
    public void testEncodeNullBigInt(TestContext ctx) {
        this.testPreparedQueryEncodeGeneric(ctx, "nullable_datatype", "test_bigint", LONG_NULL_VALUE, row -> ColumnChecker.checkColumn((int)0, (String)"test_bigint").returnsNull().forRow(row));
    }

    @Test
    public void testEncodeFloat4(TestContext ctx) {
        this.testEncodeNumber(ctx, "test_float_4", Float.valueOf(-3.40282E38f));
    }

    @Test
    public void testEncodeNullFloat4(TestContext ctx) {
        this.testPreparedQueryEncodeGeneric(ctx, "nullable_datatype", "test_float_4", FLOAT_NULL_VALUE, row -> ColumnChecker.checkColumn((int)0, (String)"test_float_4").returnsNull().forRow(row));
    }

    @Test
    public void testEncodeFloat8(TestContext ctx) {
        this.testEncodeNumber(ctx, "test_float_8", -1.7976931348623157E308);
    }

    @Test
    public void testEncodeNullFloat8(TestContext ctx) {
        this.testPreparedQueryEncodeGeneric(ctx, "nullable_datatype", "test_float_8", DOUBLE_NULL_VALUE, row -> ColumnChecker.checkColumn((int)0, (String)"test_float_8").returnsNull().forRow(row));
    }

    @Test
    public void testEncodeNumeric(TestContext ctx) {
        this.testEncodeNumber(ctx, "test_numeric", new BigDecimal("-123.13"));
    }

    @Test
    public void testEncodeNullNumeric(TestContext ctx) {
        this.testPreparedQueryEncodeGeneric(ctx, "nullable_datatype", "test_numeric", DECIMAL_NULL_VALUE, row -> ColumnChecker.checkColumn((int)0, (String)"test_numeric").returnsNull().forRow(row));
    }

    @Test
    public void testEncodeDecimal(TestContext ctx) {
        this.testEncodeNumber(ctx, "test_decimal", new BigDecimal("123456789"));
    }

    @Test
    public void testEncodeNullDecimal(TestContext ctx) {
        this.testPreparedQueryEncodeGeneric(ctx, "nullable_datatype", "test_decimal", DECIMAL_NULL_VALUE, row -> ColumnChecker.checkColumn((int)0, (String)"test_decimal").returnsNull().forRow(row));
    }

    @Test
    public void testEncodeUuid(TestContext ctx) {
        UUID value = UUID.fromString("90765de2-63a5-4d21-82b3-189e72181608");
        this.testPreparedQueryEncodeGeneric(ctx, "nullable_datatype", "test_uuid", value, row -> ColumnChecker.checkColumn((int)0, (String)"test_uuid").returns(Tuple::getValue, Row::getValue, (Object)value).returns(Tuple::getUUID, Row::getUUID, (Object)value).forRow(row));
    }

    @Test
    public void testEncodeNullUuid(TestContext ctx) {
        this.testPreparedQueryEncodeGeneric(ctx, "nullable_datatype", "test_uuid", UUID_NULL_VALUE, row -> ColumnChecker.checkColumn((int)0, (String)"test_uuid").returnsNull().forRow(row));
    }

    @Test
    public void testEncodeBit(TestContext ctx) {
        this.testEncodeBitValue(ctx, false);
    }

    @Test
    public void testEncodeNullBit(TestContext ctx) {
        this.testEncodeBitValue(ctx, BOOLEAN_NULL_VALUE);
    }

    private void testEncodeBitValue(TestContext ctx, Boolean value) {
        this.testPreparedQueryEncodeGeneric(ctx, "nullable_datatype", "test_boolean", value, row -> {
            ColumnChecker checker = ColumnChecker.checkColumn((int)0, (String)"test_boolean");
            if (value == null) {
                checker.returnsNull();
            } else {
                checker.returns(Tuple::getValue, Row::getValue, (Object)value).returns(Tuple::getBoolean, Row::getBoolean, (Object)value).returns(Boolean.class, (Object)value);
            }
            checker.forRow(row);
        });
    }

    @Test
    public void testEncodeChar(TestContext ctx) {
        this.testEncodeCharValue(ctx, "chartest");
    }

    @Test
    public void testEncodeNullChar(TestContext ctx) {
        this.testEncodeCharValue(ctx, STRING_NULL_VALUE);
    }

    private void testEncodeCharValue(TestContext ctx, String value) {
        this.testEncodeVarCharValue(ctx, "test_char", value);
    }

    @Test
    public void testEncodeVarChar(TestContext ctx) {
        this.testEncodeVarCharValue(ctx, "test_varchar", "testedvarchar");
    }

    @Test
    public void testEncodeNullVarChar(TestContext ctx) {
        this.testEncodeVarCharValue(ctx, "test_varchar", STRING_NULL_VALUE);
    }

    @Test
    public void testEncodeVarCharMax(TestContext ctx) {
        this.testEncodeVarCharValue(ctx, "test_varchar_max", "testedvarchar");
    }

    @Test
    public void testEncodeNullVarCharMax(TestContext ctx) {
        this.testEncodeVarCharValue(ctx, "test_varchar_max", STRING_NULL_VALUE);
    }

    @Test
    public void testEncodeText(TestContext ctx) {
        this.testEncodeVarCharValue(ctx, "test_text", "testedvarchar");
    }

    @Test
    public void testEncodeNullText(TestContext ctx) {
        this.testEncodeVarCharValue(ctx, "test_text", STRING_NULL_VALUE);
    }

    @Test
    public void testEncodeNText(TestContext ctx) {
        this.testEncodeVarCharValue(ctx, "test_ntext", "testedvarchar");
    }

    @Test
    public void testEncodeNullNText(TestContext ctx) {
        this.testEncodeVarCharValue(ctx, "test_ntext", STRING_NULL_VALUE);
    }

    private void testEncodeVarCharValue(TestContext ctx, String columnName, String value) {
        this.testPreparedQueryEncodeGeneric(ctx, "nullable_datatype", columnName, value, row -> {
            ColumnChecker checker = ColumnChecker.checkColumn((int)0, (String)columnName);
            if (value == null) {
                checker.returnsNull();
            } else {
                checker.returns(Tuple::getValue, Row::getValue, (Object)value).returns(Tuple::getString, Row::getString, (Object)value).returns(String.class, (Object)value);
            }
            checker.forRow(row);
        });
    }

    @Test
    public void testEncodeDate(TestContext ctx) {
        this.testEncodeDateValue(ctx, LocalDate.of(1999, 12, 31));
    }

    @Test
    public void testEncodeNullDate(TestContext ctx) {
        this.testEncodeDateValue(ctx, LOCALDATE_NULL_VALUE);
    }

    private void testEncodeDateValue(TestContext ctx, LocalDate value) {
        this.testPreparedQueryEncodeGeneric(ctx, "nullable_datatype", "test_date", value, row -> {
            ColumnChecker checker = ColumnChecker.checkColumn((int)0, (String)"test_date");
            if (value == null) {
                checker.returnsNull();
            } else {
                checker.returns(Tuple::getValue, Row::getValue, (Object)value).returns(Tuple::getLocalDate, Row::getLocalDate, (Object)value).returns(LocalDate.class, (Object)value);
            }
            checker.forRow(row);
        });
    }

    @Test
    public void testEncodeTime(TestContext ctx) {
        this.testEncodeTimeValue(ctx, LocalTime.of(23, 10, 45));
    }

    @Test
    public void testEncodeNullTime(TestContext ctx) {
        this.testEncodeTimeValue(ctx, LOCALTIME_NULL_VALUE);
    }

    private void testEncodeTimeValue(TestContext ctx, LocalTime value) {
        this.testPreparedQueryEncodeGeneric(ctx, "nullable_datatype", "test_time", value, row -> {
            ColumnChecker checker = ColumnChecker.checkColumn((int)0, (String)"test_time");
            if (value == null) {
                checker.returnsNull();
            } else {
                checker.returns(Tuple::getValue, Row::getValue, (Object)value).returns(Tuple::getLocalTime, Row::getLocalTime, (Object)value).returns(LocalTime.class, (Object)value);
            }
            checker.forRow(row);
        });
    }

    @Test
    public void testEncodeDateTime(TestContext ctx) {
        this.testEncodeDateTimeValue(ctx, LocalDateTime.of(1999, 12, 31, 23, 10, 45));
    }

    @Test
    public void testEncodeNullSmallDateTime(TestContext ctx) {
        this.testEncodeSmallDateTimeValue(ctx, LOCALDATETIME_NULL_VALUE);
    }

    private void testEncodeSmallDateTimeValue(TestContext ctx, LocalDateTime value) {
        this.testPreparedQueryEncodeGeneric(ctx, "nullable_datatype", "test_smalldatetime", value, row -> {
            ColumnChecker checker = ColumnChecker.checkColumn((int)0, (String)"test_smalldatetime");
            if (value == null) {
                checker.returnsNull();
            } else {
                checker.returns(Tuple::getValue, Row::getValue, (Object)value).returns(Tuple::getLocalDateTime, Row::getLocalDateTime, (Object)value).returns(Tuple::getLocalDate, Row::getLocalDate, (Object)value.toLocalDate()).returns(Tuple::getLocalTime, Row::getLocalTime, (Object)value.toLocalTime()).returns(LocalDateTime.class, (Object)value).forRow(row);
            }
        });
    }

    @Test
    public void testEncodeNullDateTime(TestContext ctx) {
        this.testEncodeDateTimeValue(ctx, LOCALDATETIME_NULL_VALUE);
    }

    private void testEncodeDateTimeValue(TestContext ctx, LocalDateTime value) {
        this.testPreparedQueryEncodeGeneric(ctx, "nullable_datatype", "test_datetime", value, row -> {
            ColumnChecker checker = ColumnChecker.checkColumn((int)0, (String)"test_datetime");
            if (value == null) {
                checker.returnsNull();
            } else {
                checker.returns(Tuple::getValue, Row::getValue, (Object)value).returns(Tuple::getLocalDateTime, Row::getLocalDateTime, (Object)value).returns(Tuple::getLocalDate, Row::getLocalDate, (Object)value.toLocalDate()).returns(Tuple::getLocalTime, Row::getLocalTime, (Object)value.toLocalTime()).returns(LocalDateTime.class, (Object)value).forRow(row);
            }
        });
    }

    @Test
    public void testEncodeNullDateTime2(TestContext ctx) {
        this.testEncodeDateTime2Value(ctx, LOCALDATETIME_NULL_VALUE);
    }

    private void testEncodeDateTime2Value(TestContext ctx, LocalDateTime value) {
        this.testPreparedQueryEncodeGeneric(ctx, "nullable_datatype", "test_datetime2", value, row -> {
            ColumnChecker checker = ColumnChecker.checkColumn((int)0, (String)"test_datetime2");
            if (value == null) {
                checker.returnsNull();
            } else {
                checker.returns(Tuple::getValue, Row::getValue, (Object)value).returns(Tuple::getLocalDateTime, Row::getLocalDateTime, (Object)value).returns(Tuple::getLocalDate, Row::getLocalDate, (Object)value.toLocalDate()).returns(Tuple::getLocalTime, Row::getLocalTime, (Object)value.toLocalTime()).returns(LocalDateTime.class, (Object)value).forRow(row);
            }
        });
    }

    @Test
    public void testEncodeOffsetDateTime(TestContext ctx) {
        this.testEncodeDateTimeValue(ctx, LocalDateTime.of(1999, 12, 31, 23, 10, 45).atOffset(ZoneOffset.ofHoursMinutes(-3, -15)));
    }

    @Test
    public void testEncodeNullOffsetDateTime(TestContext ctx) {
        this.testEncodeDateTimeValue(ctx, OFFSETDATETIME_NULL_VALUE);
    }

    private void testEncodeDateTimeValue(TestContext ctx, OffsetDateTime value) {
        this.testPreparedQueryEncodeGeneric(ctx, "nullable_datatype", "test_datetimeoffset", value, row -> {
            ColumnChecker checker = ColumnChecker.checkColumn((int)0, (String)"test_datetimeoffset");
            if (value == null) {
                checker.returnsNull();
            } else {
                checker.returns(Tuple::getValue, Row::getValue, (Object)value).returns(Tuple::getOffsetDateTime, Row::getOffsetDateTime, (Object)value).returns(Tuple::getLocalDateTime, Row::getLocalDateTime, (Object)value.toLocalDateTime()).returns(Tuple::getLocalDate, Row::getLocalDate, (Object)value.toLocalDate()).returns(Tuple::getLocalTime, Row::getLocalTime, (Object)value.toLocalTime()).returns(OffsetDateTime.class, (Object)value).forRow(row);
            }
        });
    }

    @Test
    public void testEncodeBinary(TestContext ctx) {
        String str = "joselito";
        Buffer value = Buffer.buffer((String)str);
        Buffer actual = Buffer.buffer((String)str).appendBytes(new byte[20 - str.length()]);
        this.testEncodeBufferValue(ctx, "test_binary", value, actual);
    }

    @Test
    public void testEncodeNullBinary(TestContext ctx) {
        this.testEncodeBufferValue(ctx, "test_binary", BUFFER_NULL_VALUE);
    }

    @Test
    public void testEncodeVarBinary(TestContext ctx) {
        this.testEncodeBufferValue(ctx, "test_varbinary", Buffer.buffer((String)"joselito"));
    }

    @Test
    public void testEncodeNullVarBinary(TestContext ctx) {
        this.testEncodeBufferValue(ctx, "test_varbinary", BUFFER_NULL_VALUE);
    }

    @Test
    public void testEncodeVarBinaryMax(TestContext ctx) {
        byte[] bytes = new byte[15360];
        ThreadLocalRandom.current().nextBytes(bytes);
        this.testEncodeBufferValue(ctx, "test_varbinary_max", Buffer.buffer((byte[])bytes));
    }

    @Test
    public void testEncodeNullVarBinaryMax(TestContext ctx) {
        this.testEncodeBufferValue(ctx, "test_varbinary_max", BUFFER_NULL_VALUE);
    }

    @Test
    public void testEncodeImage(TestContext ctx) {
        byte[] bytes = new byte[15360];
        ThreadLocalRandom.current().nextBytes(bytes);
        this.testEncodeBufferValue(ctx, "test_image", Buffer.buffer((byte[])bytes));
    }

    @Test
    public void testEncodeNullImage(TestContext ctx) {
        this.testEncodeBufferValue(ctx, "test_image", BUFFER_NULL_VALUE);
    }

    private void testEncodeBufferValue(TestContext ctx, String columnName, Object value) {
        this.testEncodeBufferValue(ctx, columnName, value, value);
    }

    @Test
    public void testEncodeNullMoney(TestContext ctx) {
        this.testEncodeNumber(ctx, "test_money", new BigDecimal("123.1313"));
    }

    @Test
    public void testEncodeNullSmallMoney(TestContext ctx) {
        this.testEncodeNumber(ctx, "test_smallmoney", new BigDecimal("123.13"));
    }

    private void testEncodeBufferValue(TestContext ctx, String columnName, Object value, Object expected) {
        Object param = value == null ? NullValue.Buffer : value;
        this.testPreparedQueryEncodeGeneric(ctx, "nullable_datatype", columnName, param, row -> {
            ColumnChecker checker = ColumnChecker.checkColumn((int)0, (String)columnName);
            if (value == null || value instanceof NullValue) {
                checker.returnsNull();
            } else {
                checker.returns(Tuple::getValue, Row::getValue, expected).returns(Tuple::getBuffer, Row::getBuffer, expected).returns(Buffer.class, (Object)((Buffer)expected)).forRow(row);
            }
        });
    }

    private void testEncodeNumber(TestContext ctx, String columnName, Number value) {
        this.testPreparedQueryEncodeGeneric(ctx, "nullable_datatype", columnName, value, row -> MSSQLPreparedQueryNullableDataTypeTest.checkNumber(row, columnName, value));
    }

    @Override
    protected void testDecodeValue(TestContext ctx, boolean isNull, String columnName, Consumer<Row> checker) {
        if (isNull) {
            this.testPreparedQueryDecodeGeneric(ctx, "nullable_datatype", columnName, "3", checker);
        } else {
            this.testPreparedQueryDecodeGeneric(ctx, "nullable_datatype", columnName, "1", checker);
        }
    }
}

