/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.mssqlclient.data;

import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.tests.mssqlclient.data.MSSQLDataTypeTestBase;
import java.math.BigDecimal;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class MSSQLMoneyDataTypeTest
extends MSSQLDataTypeTestBase {
    @Test
    public void testQueryLargeMoney(TestContext ctx) {
        this.testQueryDecodeGenericWithoutTable(ctx, "test_money", "MONEY", "922337203685477.5807", new BigDecimal("922337203685477.5807"));
    }

    @Test
    public void testQueryLargeNegativeMoney(TestContext ctx) {
        this.testQueryDecodeGenericWithoutTable(ctx, "test_money", "MONEY", "-922337203685477.5807", new BigDecimal("-922337203685477.5807"));
    }

    @Test
    public void testQueryMoneyWithCurrency(TestContext ctx) {
        this.testQueryDecodeGenericWithoutTable(ctx, "test_money", "MONEY", "$12.3456", new BigDecimal("12.3456"));
    }

    @Test
    public void testPreparedQueryLargeMoney(TestContext ctx) {
        this.testPreparedQueryDecodeGenericWithoutTable(ctx, "test_money", "MONEY", "922337203685477.5807", new BigDecimal("922337203685477.5807"));
    }

    @Test
    public void testPreparedQueryLargeNegativeMoney(TestContext ctx) {
        this.testPreparedQueryDecodeGenericWithoutTable(ctx, "test_money", "MONEY", "-922337203685477.5807", new BigDecimal("-922337203685477.5807"));
    }

    @Test
    public void testPreparedQueryMoneyWithCurrency(TestContext ctx) {
        this.testPreparedQueryDecodeGenericWithoutTable(ctx, "test_money", "MONEY", "$12.3456", new BigDecimal("12.3456"));
    }
}

