/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.mssqlclient.data;

import io.vertx.core.buffer.Buffer;
import io.vertx.ext.unit.TestContext;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.Tuple;
import io.vertx.tests.mssqlclient.data.MSSQLDataTypeTestBase;
import io.vertx.tests.sqlclient.ColumnChecker;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.UUID;
import java.util.function.Consumer;
import org.junit.Test;

public abstract class MSSQLFullDataTypeTestBase
extends MSSQLDataTypeTestBase {
    @Test
    public void testDecodeAllColumns(TestContext ctx) {
        this.testDecodeNotNullValue(ctx, "*", row -> {
            ctx.assertEquals((Object)127, row.getValue("test_tinyint"));
            ctx.assertEquals((Object)Short.MAX_VALUE, row.getValue("test_smallint"));
            ctx.assertEquals((Object)Integer.MAX_VALUE, row.getValue("test_int"));
            ctx.assertEquals((Object)Long.MAX_VALUE, row.getValue("test_bigint"));
            ctx.assertEquals((Object)Float.valueOf(3.40282E38f), row.getValue("test_float_4"));
            ctx.assertEquals((Object)Double.MAX_VALUE, row.getValue("test_float_8"));
            ctx.assertEquals((Object)new BigDecimal("999.99"), row.getValue("test_numeric"));
            ctx.assertEquals((Object)new BigDecimal("12345"), row.getValue("test_decimal"));
            ctx.assertEquals((Object)true, row.getValue("test_boolean"));
            ctx.assertEquals((Object)"testchar", row.getValue("test_char"));
            ctx.assertEquals((Object)"testvarchar", row.getValue("test_varchar"));
            ctx.assertEquals((Object)"testvarcharmax", row.getValue("test_varchar_max"));
            ctx.assertEquals((Object)"testtext", row.getValue("test_text"));
            ctx.assertEquals((Object)"testntext", row.getValue("test_ntext"));
            ctx.assertEquals((Object)LocalDate.of(2019, 1, 1), row.getValue("test_date"));
            ctx.assertEquals((Object)LocalTime.of(18, 45, 2), row.getValue("test_time"));
            ctx.assertEquals((Object)LocalDateTime.of(2019, 1, 1, 18, 45, 0), row.getValue("test_smalldatetime"));
            ctx.assertEquals((Object)LocalDateTime.of(2019, 1, 1, 18, 45, 2), row.getValue("test_datetime"));
            ctx.assertEquals((Object)LocalDateTime.of(2019, 1, 1, 18, 45, 2), row.getValue("test_datetime2"));
            ctx.assertEquals((Object)LocalDateTime.of(2019, 1, 1, 18, 45, 2).atOffset(ZoneOffset.ofHoursMinutes(-3, -15)), row.getValue("test_datetimeoffset"));
            ctx.assertEquals((Object)Buffer.buffer((String)"hello world").appendBytes(new byte[20 - "hello world".length()]), row.getValue("test_binary"));
            ctx.assertEquals((Object)Buffer.buffer((String)"big apple"), row.getValue("test_varbinary"));
            ctx.assertEquals((Object)Buffer.buffer((String)"venice of the north"), row.getValue("test_varbinary_max"));
            ctx.assertEquals((Object)Buffer.buffer((String)"paris of the west"), row.getValue("test_image"));
            ctx.assertEquals((Object)new BigDecimal("12.3456"), row.getValue("test_money"));
            ctx.assertEquals((Object)new BigDecimal("12.34"), row.getValue("test_smallmoney"));
        });
    }

    @Test
    public void testDecodeTinyInt(TestContext ctx) {
        this.testDecodeNotNullValue(ctx, "test_tinyint", row -> MSSQLFullDataTypeTestBase.checkNumber(row, "test_tinyint", (short)127));
    }

    @Test
    public void testDecodeSmallIntInt(TestContext ctx) {
        this.testDecodeNotNullValue(ctx, "test_smallint", row -> MSSQLFullDataTypeTestBase.checkNumber(row, "test_smallint", (short)Short.MAX_VALUE));
    }

    @Test
    public void testDecodeInt(TestContext ctx) {
        this.testDecodeNotNullValue(ctx, "test_int", row -> MSSQLFullDataTypeTestBase.checkNumber(row, "test_int", Integer.MAX_VALUE));
    }

    @Test
    public void testDecodeBigInt(TestContext ctx) {
        this.testDecodeNotNullValue(ctx, "test_bigint", row -> MSSQLFullDataTypeTestBase.checkNumber(row, "test_bigint", Long.MAX_VALUE));
    }

    @Test
    public void testDecodeFloat4(TestContext ctx) {
        this.testDecodeNotNullValue(ctx, "test_float_4", row -> MSSQLFullDataTypeTestBase.checkNumber(row, "test_float_4", Float.valueOf(3.40282E38f)));
    }

    @Test
    public void testDecodeFloat8(TestContext ctx) {
        this.testDecodeNotNullValue(ctx, "test_float_8", row -> MSSQLFullDataTypeTestBase.checkNumber(row, "test_float_8", Double.MAX_VALUE));
    }

    @Test
    public void testDecodeNumeric(TestContext ctx) {
        this.testDecodeNotNullValue(ctx, "test_numeric", row -> MSSQLFullDataTypeTestBase.checkNumber(row, "test_numeric", new BigDecimal("999.99")));
    }

    @Test
    public void testDecodeUuid(TestContext ctx) {
        this.testDecodeNotNullValue(ctx, "test_uuid", row -> ColumnChecker.checkColumn((int)0, (String)"test_uuid").returns(Tuple::getValue, Row::getValue, (Object)UUID.fromString("e2d1f163-40a7-480b-b1a6-07faaef8e01b")).returns(Tuple::getUUID, Row::getUUID, (Object)UUID.fromString("e2d1f163-40a7-480b-b1a6-07faaef8e01b")).forRow(row));
    }

    @Test
    public void testDecodeDecimal(TestContext ctx) {
        this.testDecodeNotNullValue(ctx, "test_decimal", row -> MSSQLFullDataTypeTestBase.checkNumber(row, "test_decimal", new BigDecimal("12345")));
    }

    @Test
    public void testDecodeBit(TestContext ctx) {
        this.testDecodeNotNullValue(ctx, "test_boolean", row -> ColumnChecker.checkColumn((int)0, (String)"test_boolean").returns(Tuple::getValue, Row::getValue, (Object)true).returns(Tuple::getBoolean, Row::getBoolean, (Object)true).returns(Boolean.class, (Object)true).forRow(row));
    }

    @Test
    public void testDecodeChar(TestContext ctx) {
        this.testDecodeNotNullValue(ctx, "test_char", row -> ColumnChecker.checkColumn((int)0, (String)"test_char").returns(Tuple::getValue, Row::getValue, (Object)"testchar").returns(Tuple::getString, Row::getString, (Object)"testchar").returns(String.class, (Object)"testchar").forRow(row));
    }

    @Test
    public void testDecodeVarChar(TestContext ctx) {
        this.testDecodeNotNullValue(ctx, "test_varchar", row -> ColumnChecker.checkColumn((int)0, (String)"test_varchar").returns(Tuple::getValue, Row::getValue, (Object)"testvarchar").returns(Tuple::getString, Row::getString, (Object)"testvarchar").returns(String.class, (Object)"testvarchar").forRow(row));
    }

    @Test
    public void testDecodeDate(TestContext ctx) {
        this.testDecodeNotNullValue(ctx, "test_date", row -> ColumnChecker.checkColumn((int)0, (String)"test_date").returns(Tuple::getValue, Row::getValue, (Object)LocalDate.of(2019, 1, 1)).returns(Tuple::getLocalDate, Row::getLocalDate, (Object)LocalDate.of(2019, 1, 1)).returns(LocalDate.class, (Object)LocalDate.of(2019, 1, 1)).forRow(row));
    }

    @Test
    public void testDecodeTime(TestContext ctx) {
        this.testDecodeNotNullValue(ctx, "test_time", row -> ColumnChecker.checkColumn((int)0, (String)"test_time").returns(Tuple::getValue, Row::getValue, (Object)LocalTime.of(18, 45, 2)).returns(Tuple::getLocalTime, Row::getLocalTime, (Object)LocalTime.of(18, 45, 2)).returns(LocalTime.class, (Object)LocalTime.of(18, 45, 2)).forRow(row));
    }

    @Test
    public void testDecodeSmallDateTime(TestContext ctx) {
        this.testDecodeNotNullValue(ctx, "test_smalldatetime", row -> ColumnChecker.checkColumn((int)0, (String)"test_smalldatetime").returns(Tuple::getValue, Row::getValue, (Object)LocalDateTime.of(2019, 1, 1, 18, 45, 0)).returns(Tuple::getLocalDateTime, Row::getLocalDateTime, (Object)LocalDateTime.of(2019, 1, 1, 18, 45, 0)).returns(Tuple::getLocalDate, Row::getLocalDate, (Object)LocalDate.of(2019, 1, 1)).returns(Tuple::getLocalTime, Row::getLocalTime, (Object)LocalTime.of(18, 45, 0)).returns(LocalDateTime.class, (Object)LocalDateTime.of(2019, 1, 1, 18, 45, 0)).forRow(row));
    }

    @Test
    public void testDecodeDateTime(TestContext ctx) {
        this.testDecodeNotNullValue(ctx, "test_datetime", row -> ColumnChecker.checkColumn((int)0, (String)"test_datetime").returns(Tuple::getValue, Row::getValue, (Object)LocalDateTime.of(2019, 1, 1, 18, 45, 2)).returns(Tuple::getLocalDateTime, Row::getLocalDateTime, (Object)LocalDateTime.of(2019, 1, 1, 18, 45, 2)).returns(Tuple::getLocalDate, Row::getLocalDate, (Object)LocalDate.of(2019, 1, 1)).returns(Tuple::getLocalTime, Row::getLocalTime, (Object)LocalTime.of(18, 45, 2)).returns(LocalDateTime.class, (Object)LocalDateTime.of(2019, 1, 1, 18, 45, 2)).forRow(row));
    }

    @Test
    public void testDecodeDateTime2(TestContext ctx) {
        this.testDecodeNotNullValue(ctx, "test_datetime2", row -> ColumnChecker.checkColumn((int)0, (String)"test_datetime2").returns(Tuple::getValue, Row::getValue, (Object)LocalDateTime.of(2019, 1, 1, 18, 45, 2)).returns(Tuple::getLocalDateTime, Row::getLocalDateTime, (Object)LocalDateTime.of(2019, 1, 1, 18, 45, 2)).returns(Tuple::getLocalDate, Row::getLocalDate, (Object)LocalDate.of(2019, 1, 1)).returns(Tuple::getLocalTime, Row::getLocalTime, (Object)LocalTime.of(18, 45, 2)).returns(LocalDateTime.class, (Object)LocalDateTime.of(2019, 1, 1, 18, 45, 2)).forRow(row));
    }

    @Test
    public void testDecodeOffsetDateTime(TestContext ctx) {
        this.testDecodeNotNullValue(ctx, "test_datetimeoffset", row -> ColumnChecker.checkColumn((int)0, (String)"test_datetimeoffset").returns(Tuple::getValue, Row::getValue, (Object)LocalDateTime.of(2019, 1, 1, 18, 45, 2).atOffset(ZoneOffset.ofHoursMinutes(-3, -15))).returns(Tuple::getOffsetDateTime, Row::getOffsetDateTime, (Object)LocalDateTime.of(2019, 1, 1, 18, 45, 2).atOffset(ZoneOffset.ofHoursMinutes(-3, -15))).returns(Tuple::getLocalDateTime, Row::getLocalDateTime, (Object)LocalDateTime.of(2019, 1, 1, 18, 45, 2)).returns(Tuple::getLocalDate, Row::getLocalDate, (Object)LocalDate.of(2019, 1, 1)).returns(Tuple::getLocalTime, Row::getLocalTime, (Object)LocalTime.of(18, 45, 2)).returns(OffsetDateTime.class, (Object)LocalDateTime.of(2019, 1, 1, 18, 45, 2).atOffset(ZoneOffset.ofHoursMinutes(-3, -15))).forRow(row));
    }

    @Test
    public void testDecodeBinary(TestContext ctx) {
        String str = "hello world";
        Buffer expected = Buffer.buffer((String)str).appendBytes(new byte[20 - str.length()]);
        this.testDecodeNotNullValue(ctx, "test_binary", row -> ColumnChecker.checkColumn((int)0, (String)"test_binary").returns(Tuple::getValue, Row::getValue, (Object)expected).returns(Tuple::getBuffer, Row::getBuffer, (Object)expected).returns(Buffer.class, (Object)expected).forRow(row));
    }

    @Test
    public void testDecodeVarBinary(TestContext ctx) {
        this.testDecodeNotNullValue(ctx, "test_varbinary", row -> ColumnChecker.checkColumn((int)0, (String)"test_varbinary").returns(Tuple::getValue, Row::getValue, (Object)Buffer.buffer((String)"big apple")).returns(Tuple::getBuffer, Row::getBuffer, (Object)Buffer.buffer((String)"big apple")).returns(Buffer.class, (Object)Buffer.buffer((String)"big apple")).forRow(row));
    }

    @Test
    public void testDecodeMoney(TestContext ctx) {
        this.testDecodeNotNullValue(ctx, "test_money", row -> MSSQLFullDataTypeTestBase.checkNumber(row, "test_money", new BigDecimal("12.3456")));
    }

    @Test
    public void testDecodeSmallMoney(TestContext ctx) {
        this.testDecodeNotNullValue(ctx, "test_smallmoney", row -> MSSQLFullDataTypeTestBase.checkNumber(row, "test_smallmoney", new BigDecimal("12.34")));
    }

    protected abstract void testDecodeValue(TestContext var1, boolean var2, String var3, Consumer<Row> var4);

    private void testDecodeNotNullValue(TestContext ctx, String columnName, Consumer<Row> checker) {
        this.testDecodeValue(ctx, false, columnName, checker);
    }

    protected static void checkNumber(Row row, String columnName, Number value) {
        ColumnChecker.checkColumn((int)0, (String)columnName).returns(Tuple::getValue, Row::getValue, (Object)value).returns(Tuple::getShort, Row::getShort, (Object)value.shortValue()).returns(Tuple::getInteger, Row::getInteger, (Object)value.intValue()).returns(Tuple::getLong, Row::getLong, (Object)value.longValue()).returns(Tuple::getFloat, Row::getFloat, (Object)Float.valueOf(value.floatValue())).returns(Tuple::getDouble, Row::getDouble, (Object)value.doubleValue()).returns(Tuple::getBigDecimal, Row::getBigDecimal, (Object)new BigDecimal(value.toString())).returns(Byte.class, (Object)value.byteValue()).returns(BigDecimal.class, (Object)new BigDecimal(value.toString())).forRow(row);
    }
}

