/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.mssqlclient.data;

import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.tests.mssqlclient.data.MSSQLDataTypeTestBase;
import java.time.LocalDateTime;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class MSSQLDateTimeDataTypeTest
extends MSSQLDataTypeTestBase {
    private static final int[] HUNDRED_NANOS = new int[]{0, 1000000, 1100000, 1130000, 1170000};

    @Test
    public void testQueryTime(TestContext ctx) {
        LocalDateTime localDateTime = LocalDateTime.of(2021, 3, 26, 8, 33, 21);
        for (int i = 0; i <= 4; ++i) {
            String columnName = String.format("test_datetime_%d", i);
            LocalDateTime expected = localDateTime.withNano(100 * HUNDRED_NANOS[i]);
            String value = String.format("'%s'", expected);
            this.testQueryDecodeGenericWithoutTable(ctx, columnName, "DATETIME", value, expected);
        }
    }

    @Test
    public void testPreparedQueryTime(TestContext ctx) {
        LocalDateTime localDateTime = LocalDateTime.of(2021, 3, 26, 8, 33, 21);
        for (int i = 0; i <= 4; ++i) {
            String columnName = String.format("test_datetime_%d", i);
            LocalDateTime expected = localDateTime.withNano(100 * HUNDRED_NANOS[i]);
            String value = String.format("'%s'", expected);
            this.testPreparedQueryDecodeGenericWithoutTable(ctx, columnName, "DATETIME", value, expected);
        }
    }
}

