/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.mssqlclient;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.Repeat;
import io.vertx.ext.unit.junit.RepeatRule;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.mssqlclient.MSSQLConnectOptions;
import io.vertx.mssqlclient.MSSQLConnection;
import io.vertx.mssqlclient.MSSQLException;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.data.NullValue;
import io.vertx.tests.mssqlclient.MSSQLTestBase;
import java.time.Clock;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class MSSQLQueriesTest
extends MSSQLTestBase {
    @Rule
    public RepeatRule rule = new RepeatRule();
    Vertx vertx;
    MSSQLConnection connection;

    @Before
    public void setup(TestContext ctx) {
        this.vertx = Vertx.vertx();
        options = new MSSQLConnectOptions(MSSQLTestBase.options);
        MSSQLConnection.connect((Vertx)this.vertx, (MSSQLConnectOptions)options).onComplete(ctx.asyncAssertSuccess(conn -> {
            this.connection = conn;
        }));
    }

    @After
    public void tearDown(TestContext ctx) {
        if (this.connection != null) {
            this.connection.close().onComplete(ctx.asyncAssertSuccess());
        }
        this.vertx.close().onComplete(ctx.asyncAssertSuccess());
    }

    @Test
    public void testSimpleQueryOrderBy(TestContext ctx) {
        this.connection.query("SELECT message FROM immutable ORDER BY message DESC").execute().onComplete(ctx.asyncAssertSuccess(rs -> ctx.assertTrue(rs.size() > 1)));
    }

    @Test
    public void testPreparedQueryOrderBy(TestContext ctx) {
        this.connection.preparedQuery("SELECT message FROM immutable WHERE id BETWEEN @p1 AND @p2 ORDER BY message DESC").execute(Tuple.of((Object)4, (Object)9)).onComplete(ctx.asyncAssertSuccess(rs -> ctx.assertEquals((Object)6, (Object)rs.size())));
    }

    @Test
    @Repeat(value=50)
    public void testQueryCurrentTimestamp(TestContext ctx) {
        LocalDateTime start = LocalDateTime.now(Clock.systemUTC());
        this.connection.query("SELECT current_timestamp").execute().onComplete(ctx.asyncAssertSuccess(rs -> {
            Object value = ((Row)rs.iterator().next()).getValue(0);
            ctx.assertTrue(value instanceof LocalDateTime);
            LocalDateTime localDateTime = (LocalDateTime)value;
            ctx.assertTrue(Math.abs(localDateTime.until(start, ChronoUnit.SECONDS)) < 1L);
        }));
    }

    @Test
    public void testCreateTable(TestContext ctx) {
        this.connection.query("drop table if exists Basic").execute().onComplete(ctx.asyncAssertSuccess(drop -> this.connection.preparedQuery("create table Basic (id int, dessimal numeric(19,2), primary key (id))").execute().onComplete(ctx.asyncAssertSuccess(create -> this.connection.preparedQuery("INSERT INTO Basic (id, dessimal) values (3, @p1)").execute(Tuple.of((Object)NullValue.BigDecimal)).onComplete(ctx.asyncAssertSuccess())))));
    }

    @Test
    public void testInsertReturning(TestContext ctx) {
        this.connection.preparedQuery("insert into EntityWithIdentity (name) OUTPUT INSERTED.id, INSERTED.name VALUES (@p1)").execute(Tuple.of((Object)"John")).onComplete(ctx.asyncAssertSuccess(result -> {
            Row row = (Row)result.iterator().next();
            ctx.assertNotNull((Object)row.getInteger("id"));
            ctx.assertEquals((Object)"John", (Object)row.getString("name"));
        }));
    }

    @Test
    public void testQueryNonExisting(TestContext ctx) {
        this.connection.preparedQuery("DELETE FROM Fonky.Family").execute(Tuple.tuple()).onComplete(ctx.asyncAssertFailure(t -> {
            ctx.verify(unused -> MatcherAssert.assertThat((Object)t, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(MSSQLException.class))));
            MSSQLException mssqlException = (MSSQLException)t;
            ctx.assertEquals((Object)208, (Object)mssqlException.getErrorCode());
        }));
    }

    @Test
    public void testMultiplePacketsDecoding(TestContext ctx) {
        String sql = "SELECT table_name  AS TABLE_NAME,\n       column_name AS COLUMN_NAME,\n       data_type   AS TYPE_NAME,\n       NULL        AS COLUMN_SIZE,\n       NULL        AS DECIMAL_DIGITS,\n       is_nullable AS IS_NULLABLE,\n       NULL        AS DATA_TYPE\nFROM information_schema.columns\nORDER BY table_catalog, table_schema, table_name, column_name, ordinal_position";
        this.connection.preparedQuery(sql).execute(Tuple.tuple()).onComplete(ctx.asyncAssertSuccess(rows -> ctx.assertTrue(rows.size() > 0)));
    }

    @Test
    public void testExecuteStoredProcedure(TestContext ctx) {
        Async async = ctx.async();
        List rows = Collections.synchronizedList(new ArrayList());
        this.connection.prepare("EXEC GetFortune").onComplete(ctx.asyncAssertSuccess(ps -> ps.createStream(2).exceptionHandler(arg_0 -> ((TestContext)ctx).fail(arg_0)).endHandler(v -> {
            ctx.assertEquals((Object)6, (Object)rows.size());
            async.complete();
        }).handler(row -> {
            ctx.assertEquals((Object)2, (Object)row.size());
            rows.add(row);
        })));
    }

    @Test
    public void testQuerySequences(TestContext ctx) {
        List futures = Stream.of("tinyint", "smallint", "int", "bigint").flatMap(type -> Stream.of(String.format("DROP SEQUENCE IF EXISTS seq_%s", type), String.format("CREATE SEQUENCE seq_%s AS %s", type, type))).map(sql -> this.connection.query(sql).execute()).collect(Collectors.toList());
        Future.all(futures).onComplete(ctx.asyncAssertSuccess(cf -> this.connection.query("SELECT * FROM INFORMATION_SCHEMA.SEQUENCES WHERE SEQUENCE_NAME LIKE 'seq_%'").execute().onComplete(ctx.asyncAssertSuccess(rows -> {
            for (Row row : rows) {
                ctx.assertEquals((Object)row.getString("SEQUENCE_NAME"), (Object)("seq_" + row.getString("DECLARED_DATA_TYPE")));
            }
        }))));
    }
}

