/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.mssqlclient;

import io.vertx.core.Vertx;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.mssqlclient.MSSQLConnectOptions;
import io.vertx.mssqlclient.MSSQLConnection;
import io.vertx.mssqlclient.MSSQLInfo;
import io.vertx.tests.mssqlclient.MSSQLTestBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class MSSQLInfoTest
extends MSSQLTestBase {
    Vertx vertx;
    MSSQLConnection connection;

    @Before
    public void setup(TestContext ctx) {
        this.vertx = Vertx.vertx();
        options = new MSSQLConnectOptions(MSSQLTestBase.options);
        MSSQLConnection.connect((Vertx)this.vertx, (MSSQLConnectOptions)options).onComplete(ctx.asyncAssertSuccess(conn -> {
            this.connection = conn;
        }));
    }

    @After
    public void tearDown(TestContext ctx) {
        if (this.connection != null) {
            this.connection.close().onComplete(ctx.asyncAssertSuccess());
        }
        this.vertx.close().onComplete(ctx.asyncAssertSuccess());
    }

    @Test
    public void testHandleInfo(TestContext ctx) {
        String msg = "Hi there";
        Async async = ctx.async();
        List infos = Collections.synchronizedList(new ArrayList());
        this.connection.infoHandler(e -> {
            infos.add(e);
            async.complete();
        });
        this.connection.query(String.format("PRINT '%s'", msg)).execute().onComplete(ctx.asyncAssertSuccess());
        async.await();
        Assert.assertEquals((long)1L, (long)infos.size());
        MSSQLInfo info = (MSSQLInfo)infos.get(0);
        Assert.assertEquals((Object)msg, (Object)info.getMessage());
        Assert.assertEquals((long)0L, (long)info.getSeverity());
    }
}

