/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.mssqlclient;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.net.ClientSSLOptions;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.mssqlclient.MSSQLConnection;
import io.vertx.sqlclient.Tuple;
import io.vertx.tests.mssqlclient.MSSQLEncryptionTestBase;
import io.vertx.tests.mssqlclient.junit.MSSQLRule;
import java.util.Arrays;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class MSSQLEncryptionTest
extends MSSQLEncryptionTestBase {
    @ClassRule
    public static MSSQLRule rule = new MSSQLRule(MSSQLRule.Config.TLS);

    @Override
    protected MSSQLRule rule() {
        return rule;
    }

    @Test
    public void testEncryptionLoginOnly(TestContext ctx) {
        this.setOptions(rule.options());
        this.asyncAssertConnectionUnencrypted(ctx);
    }

    @Test
    public void testSmallerPacketSize(TestContext ctx) {
        this.setOptions(rule.options().setSsl(true).setSslOptions(new ClientSSLOptions().setTrustAll(true)).setPacketSize(512));
        char[] chars = new char[200];
        Arrays.fill(chars, 'a');
        String str = new String(chars);
        this.connect((Handler<AsyncResult<MSSQLConnection>>)ctx.asyncAssertSuccess(conn -> conn.query("CREATE TABLE #TestSmallerPacketSize (text NVARCHAR(MAX))").execute().onComplete(ctx.asyncAssertSuccess(v -> conn.preparedQuery("INSERT INTO #TestSmallerPacketSize (text) VALUES (@p1)").execute(Tuple.of((Object)str)).onComplete(ctx.asyncAssertSuccess())))));
    }
}

