/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.mssqlclient;

import io.vertx.mssqlclient.MSSQLConnectOptions;
import org.junit.Assert;
import org.junit.Test;

public class MSSQLConnectOptionsProviderTest {
    private String connectionUri;
    private MSSQLConnectOptions expectedConfiguration;
    private MSSQLConnectOptions actualConfiguration;

    @Test
    public void testValidUri1() {
        this.connectionUri = "sqlserver://localhost";
        this.actualConfiguration = MSSQLConnectOptions.fromUri((String)this.connectionUri);
        this.expectedConfiguration = new MSSQLConnectOptions();
        MSSQLConnectOptionsProviderTest.assertEquals(this.expectedConfiguration, this.actualConfiguration);
    }

    @Test
    public void testValidUri2() {
        this.connectionUri = "sqlserver://myhost";
        this.actualConfiguration = MSSQLConnectOptions.fromUri((String)this.connectionUri);
        this.expectedConfiguration = new MSSQLConnectOptions().setHost("myhost");
        MSSQLConnectOptionsProviderTest.assertEquals(this.expectedConfiguration, this.actualConfiguration);
    }

    @Test
    public void testValidUri3() {
        this.connectionUri = "sqlserver://myhost:3306";
        this.actualConfiguration = MSSQLConnectOptions.fromUri((String)this.connectionUri);
        this.expectedConfiguration = new MSSQLConnectOptions().setHost("myhost").setPort(3306);
        MSSQLConnectOptionsProviderTest.assertEquals(this.expectedConfiguration, this.actualConfiguration);
    }

    @Test
    public void testValidUri4() {
        this.connectionUri = "sqlserver://myhost/mydb";
        this.actualConfiguration = MSSQLConnectOptions.fromUri((String)this.connectionUri);
        this.expectedConfiguration = new MSSQLConnectOptions().setHost("myhost").setDatabase("mydb");
        MSSQLConnectOptionsProviderTest.assertEquals(this.expectedConfiguration, this.actualConfiguration);
    }

    @Test
    public void testValidUri5() {
        this.connectionUri = "sqlserver://user@myhost";
        this.actualConfiguration = MSSQLConnectOptions.fromUri((String)this.connectionUri);
        this.expectedConfiguration = new MSSQLConnectOptions().setUser("user").setHost("myhost");
        MSSQLConnectOptionsProviderTest.assertEquals(this.expectedConfiguration, this.actualConfiguration);
    }

    @Test
    public void testValidUri6() {
        this.connectionUri = "sqlserver://user:secret@myhost";
        this.actualConfiguration = MSSQLConnectOptions.fromUri((String)this.connectionUri);
        this.expectedConfiguration = new MSSQLConnectOptions().setUser("user").setPassword("secret").setHost("myhost");
        MSSQLConnectOptionsProviderTest.assertEquals(this.expectedConfiguration, this.actualConfiguration);
    }

    @Test
    public void testValidUri7() {
        this.connectionUri = "sqlserver://other@localhost/otherdb?port=3306&password=secret";
        this.actualConfiguration = MSSQLConnectOptions.fromUri((String)this.connectionUri);
        this.expectedConfiguration = new MSSQLConnectOptions().setUser("other").setPassword("secret").setHost("localhost").setPort(3306).setDatabase("otherdb");
        MSSQLConnectOptionsProviderTest.assertEquals(this.expectedConfiguration, this.actualConfiguration);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidUri1() {
        this.connectionUri = "sqlserver://username:password@loc//dbname";
        this.actualConfiguration = MSSQLConnectOptions.fromUri((String)this.connectionUri);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidUri2() {
        this.connectionUri = "sqlserver://user@:passowrd@localhost/dbname/qwer";
        this.actualConfiguration = MSSQLConnectOptions.fromUri((String)this.connectionUri);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidUri3() {
        this.connectionUri = "sqlserver://user:password@localhost:655355/dbname";
        this.actualConfiguration = MSSQLConnectOptions.fromUri((String)this.connectionUri);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidUri4() {
        this.connectionUri = "sqlserver://user@localhost?port=1234&port";
        this.actualConfiguration = MSSQLConnectOptions.fromUri((String)this.connectionUri);
    }

    private static void assertEquals(MSSQLConnectOptions expectedConfiguration, MSSQLConnectOptions actualConfiguration) {
        Assert.assertEquals((Object)expectedConfiguration.toJson(), (Object)actualConfiguration.toJson());
    }
}

