package io.vertx.mssqlclient;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import java.time.Instant;
import java.time.format.DateTimeFormatter;

/**
 * Converter and mapper for {@link io.vertx.mssqlclient.MSSQLInfo}.
 * NOTE: This class has been automatically generated from the {@link io.vertx.mssqlclient.MSSQLInfo} original class using Vert.x codegen.
 */
public class MSSQLInfoConverter {

   static void fromJson(Iterable<java.util.Map.Entry<String, Object>> json, MSSQLInfo obj) {
    for (java.util.Map.Entry<String, Object> member : json) {
      switch (member.getKey()) {
        case "number":
          if (member.getValue() instanceof Number) {
            obj.setNumber(((Number)member.getValue()).intValue());
          }
          break;
        case "state":
          if (member.getValue() instanceof Number) {
            obj.setState(((Number)member.getValue()).byteValue());
          }
          break;
        case "severity":
          if (member.getValue() instanceof Number) {
            obj.setSeverity(((Number)member.getValue()).byteValue());
          }
          break;
        case "message":
          if (member.getValue() instanceof String) {
            obj.setMessage((String)member.getValue());
          }
          break;
        case "serverName":
          if (member.getValue() instanceof String) {
            obj.setServerName((String)member.getValue());
          }
          break;
        case "procedureName":
          if (member.getValue() instanceof String) {
            obj.setProcedureName((String)member.getValue());
          }
          break;
        case "lineNumber":
          if (member.getValue() instanceof Number) {
            obj.setLineNumber(((Number)member.getValue()).intValue());
          }
          break;
      }
    }
  }

   static void toJson(MSSQLInfo obj, JsonObject json) {
    toJson(obj, json.getMap());
  }

   static void toJson(MSSQLInfo obj, java.util.Map<String, Object> json) {
    json.put("number", obj.getNumber());
    json.put("state", obj.getState());
    json.put("severity", obj.getSeverity());
    if (obj.getMessage() != null) {
      json.put("message", obj.getMessage());
    }
    if (obj.getServerName() != null) {
      json.put("serverName", obj.getServerName());
    }
    if (obj.getProcedureName() != null) {
      json.put("procedureName", obj.getProcedureName());
    }
    json.put("lineNumber", obj.getLineNumber());
  }
}
