/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.impl;

import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.net.HostAndPort;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.NetSocketInternal;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.mssqlclient.MSSQLConnectOptions;
import io.vertx.mssqlclient.impl.MSSQLConnectionImpl;
import io.vertx.mssqlclient.impl.MSSQLSocketConnection;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.ConnectionFactoryBase;
import io.vertx.sqlclient.spi.ConnectionFactory;
import java.util.Map;
import java.util.function.Supplier;

public class MSSQLConnectionFactory
extends ConnectionFactoryBase {
    public MSSQLConnectionFactory(VertxInternal vertx, Supplier<? extends Future<? extends SqlConnectOptions>> options) {
        super(vertx, options);
    }

    protected Future<Connection> doConnectInternal(SqlConnectOptions options, ContextInternal context) {
        return this.connectOrRedirect(MSSQLConnectOptions.wrap(options), context, 0);
    }

    private Future<Connection> connectOrRedirect(MSSQLConnectOptions options, ContextInternal context, int redirections) {
        if (redirections > 1) {
            return context.failedFuture("The client can be redirected only once");
        }
        SocketAddress server = options.getSocketAddress();
        boolean clientSslConfig = options.isSsl();
        NetClient netClient = this.netClient(new NetClientOptions((NetClientOptions)options).setSsl(false));
        return netClient.connect(server).map(so -> this.createSocketConnection((NetSocket)so, options, context)).compose(conn -> conn.sendPreLoginMessage(clientSslConfig).compose(encryptionLevel -> this.login((MSSQLSocketConnection)((Object)conn), options, (Byte)encryptionLevel, context))).compose(connBase -> {
            MSSQLSocketConnection conn = (MSSQLSocketConnection)((Object)connBase);
            HostAndPort alternateServer = conn.getAlternateServer();
            if (alternateServer == null) {
                return context.succeededFuture((Object)conn);
            }
            PromiseInternal closePromise = context.promise();
            conn.close(null, (Promise)closePromise);
            return closePromise.future().transform(v -> {
                MSSQLConnectOptions connectOptions = new MSSQLConnectOptions(options).setHost(alternateServer.host()).setPort(alternateServer.port());
                return this.connectOrRedirect(connectOptions, context, redirections + 1);
            });
        });
    }

    private MSSQLSocketConnection createSocketConnection(NetSocket so, MSSQLConnectOptions options, ContextInternal context) {
        VertxMetrics vertxMetrics = this.vertx.metricsSPI();
        ClientMetrics metrics = vertxMetrics != null ? vertxMetrics.createClientMetrics(options.getSocketAddress(), "sql", options.getMetricsName()) : null;
        MSSQLSocketConnection conn = new MSSQLSocketConnection((NetSocketInternal)so, metrics, options, false, 0, sql -> true, 1, context);
        conn.init();
        return conn;
    }

    private Future<Connection> login(MSSQLSocketConnection conn, MSSQLConnectOptions options, Byte encryptionLevel, ContextInternal context) {
        boolean clientSslConfig = options.isSsl();
        if (clientSslConfig && encryptionLevel != 1 && encryptionLevel != 3) {
            PromiseInternal closePromise = context.promise();
            conn.close(null, (Promise)closePromise);
            return closePromise.future().transform(v -> context.failedFuture("The client is configured for encryption but the server does not support it"));
        }
        Future<Void> future = encryptionLevel != 2 ? conn.enableSsl(clientSslConfig, encryptionLevel, options) : context.succeededFuture();
        String username = options.getUser();
        String password = options.getPassword();
        String database = options.getDatabase();
        Map properties = options.getProperties();
        return future.compose(v -> conn.sendLoginMessage(username, password, database, properties));
    }

    public Future<SqlConnection> connect(Context context, SqlConnectOptions options) {
        ContextInternal ctx = (ContextInternal)context;
        PromiseInternal promise = ctx.promise();
        this.connect(MSSQLConnectionFactory.asEventLoopContext((ContextInternal)ctx), options).map(conn -> {
            MSSQLConnectionImpl msConn = new MSSQLConnectionImpl(ctx, (ConnectionFactory)this, (Connection)conn);
            conn.init((Connection.Holder)msConn);
            return msConn;
        }).onComplete((Handler)promise);
        return promise.future();
    }
}

