/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.tck;

import io.vertx.core.Vertx;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.mssqlclient.tck.ClientConfig;
import io.vertx.mssqlclient.tck.MSSQLPreparedQueryTestBase;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.Tuple;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class MSSQLPreparedQueryTest
extends MSSQLPreparedQueryTestBase {
    public void setUp(TestContext ctx) throws Exception {
        this.vertx = Vertx.vertx();
        this.initConnector();
        this.cleanTestTable(ctx);
    }

    protected void initConnector() {
        this.options = rule.options();
        this.connector = ClientConfig.CONNECT.connect(this.vertx, this.options);
    }

    @Test
    public void closePreparedNotExecuted(TestContext ctx) {
        this.connector.connect(ctx.asyncAssertSuccess(conn -> conn.prepare("SELECT * FROM IMMUTABLE WHERE id = @p1", ctx.asyncAssertSuccess(ps -> ps.close(ctx.asyncAssertSuccess())))));
    }

    @Test
    public void closePreparedExecuted(TestContext ctx) {
        this.connector.connect(ctx.asyncAssertSuccess(conn -> conn.prepare("SELECT * FROM IMMUTABLE WHERE id = @p1", ctx.asyncAssertSuccess(ps -> ps.query().execute(Tuple.of((Object)3), ctx.asyncAssertSuccess(rs -> {
            Row row = (Row)rs.iterator().next();
            ctx.assertEquals((Object)3, (Object)row.getInteger(0));
            ctx.assertEquals((Object)"After enough decimal places, nobody gives a damn.", (Object)row.getString(1));
            ps.query().execute(Tuple.of((Object)7), ctx.asyncAssertSuccess(rs2 -> {
                Row row2 = (Row)rs2.iterator().next();
                ctx.assertEquals((Object)7, (Object)row2.getInteger(0));
                ctx.assertEquals((Object)"Any program that runs right is obsolete.", (Object)row2.getString(1));
                ps.close(ctx.asyncAssertSuccess());
            }));
        }))))));
    }
}

