/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.impl;

import io.vertx.core.json.JsonObject;
import io.vertx.mssqlclient.impl.MSSQLConnectionUriParser;
import org.junit.Assert;
import org.junit.Test;

public class MSSQLConnectionUriParserTest {
    private String uri;
    private JsonObject actualParsedResult;
    private JsonObject expectedParsedResult;

    @Test
    public void testParsingUriSchemeDesignator() {
        this.uri = "sqlserver://localhost";
        this.actualParsedResult = MSSQLConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("host", (Object)"localhost");
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParsingInvalidUriSchemeDesignator() {
        this.uri = "sqlservere://localhost";
        this.actualParsedResult = MSSQLConnectionUriParser.parse((String)this.uri);
    }

    @Test
    public void testParsingUserWithoutPassword() {
        this.uri = "sqlserver://user@localhost";
        this.actualParsedResult = MSSQLConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("user", (Object)"user").put("host", (Object)"localhost");
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test
    public void testParsingUserWithEmptyPassword() {
        this.uri = "sqlserver://user:@localhost";
        this.actualParsedResult = MSSQLConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("user", (Object)"user").put("password", (Object)"").put("host", (Object)"localhost");
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test
    public void testParsingUserWithPassword() {
        this.uri = "sqlserver://user:secret@localhost";
        this.actualParsedResult = MSSQLConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("user", (Object)"user").put("password", (Object)"secret").put("host", (Object)"localhost");
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test
    public void testParsingPasswordWithCircumflex() {
        this.uri = "sqlserver://user:secr^t@localhost";
        this.actualParsedResult = MSSQLConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("user", (Object)"user").put("password", (Object)"secr^t").put("host", (Object)"localhost");
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParsingPasswordWithoutUser() {
        this.uri = "sqlserver://:secret@localhost";
        this.actualParsedResult = MSSQLConnectionUriParser.parse((String)this.uri);
    }

    @Test
    public void testParsingHostName() {
        this.uri = "sqlserver://vertx.io";
        this.actualParsedResult = MSSQLConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("host", (Object)"vertx.io");
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test
    public void testParsingIpv4Address() {
        this.uri = "sqlserver://192.168.1.1";
        this.actualParsedResult = MSSQLConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("host", (Object)"192.168.1.1");
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test
    public void testParsingIpv6Address() {
        this.uri = "sqlserver://[2001:db8::1234]";
        this.actualParsedResult = MSSQLConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("host", (Object)"2001:db8::1234");
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test
    public void testParsingPort() {
        this.uri = "sqlserver://localhost:1234";
        this.actualParsedResult = MSSQLConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("host", (Object)"localhost").put("port", (Object)1234);
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test
    public void testParsingDatabaseName() {
        this.uri = "sqlserver://localhost/mydb";
        this.actualParsedResult = MSSQLConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("host", (Object)"localhost").put("database", (Object)"mydb");
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test
    public void testParsingOneAttribute() {
        this.uri = "sqlserver://localhost?user=other";
        this.actualParsedResult = MSSQLConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("host", (Object)"localhost").put("user", (Object)"other");
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test
    public void testParsingParameters() {
        this.uri = "sqlserver://localhost?user=other&password=secret&port=1234";
        this.actualParsedResult = MSSQLConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("host", (Object)"localhost").put("user", (Object)"other").put("password", (Object)"secret").put("port", (Object)1234);
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test
    public void testParsingHostWithPort() {
        this.uri = "sqlserver://localhost:1234";
        this.actualParsedResult = MSSQLConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("host", (Object)"localhost").put("port", (Object)1234);
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test
    public void testParsingEncodedDatabase() {
        this.uri = "sqlserver://user_name@198.51.100.2:3306/world%5Fx";
        this.actualParsedResult = MSSQLConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("user", (Object)"user_name").put("host", (Object)"198.51.100.2").put("port", (Object)3306).put("database", (Object)"world_x");
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParsingInvalidUri1() {
        this.uri = "sqlserver://us@er@@";
        this.actualParsedResult = MSSQLConnectionUriParser.parse((String)this.uri);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParsingInvalidUri2() {
        this.uri = "sqlserver://user/mydb//";
        this.actualParsedResult = MSSQLConnectionUriParser.parse((String)this.uri);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParsingInvalidUri3() {
        this.uri = "sqlserver:///dbname/?host=localhost";
        this.actualParsedResult = MSSQLConnectionUriParser.parse((String)this.uri);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParsingInvalidUri4() {
        this.uri = "sqlserver://user::1234";
        this.actualParsedResult = MSSQLConnectionUriParser.parse((String)this.uri);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParsingInvalidUri5() {
        this.uri = "sqlserver://@:1234";
        this.actualParsedResult = MSSQLConnectionUriParser.parse((String)this.uri);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParsingInvalidUri6() {
        this.uri = "sqlserver://:123:";
        this.actualParsedResult = MSSQLConnectionUriParser.parse((String)this.uri);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParsingInvalidUri7() {
        this.uri = "sqlserver://@@/dbname?host";
        this.actualParsedResult = MSSQLConnectionUriParser.parse((String)this.uri);
    }

    @Test
    public void testParsingUserInfoContainExclamationMark() {
        this.uri = "sqlserver://user!name:dd!dd@127.0.0.1:3306/dbname";
        this.actualParsedResult = MSSQLConnectionUriParser.parse((String)this.uri);
    }

    @Test
    public void testParsingDatabaseContainExclamationMark() {
        this.uri = "sqlserver://username:dddd@127.0.0.1:3306/!dbname";
        this.actualParsedResult = MSSQLConnectionUriParser.parse((String)this.uri);
    }

    @Test
    public void testParsingUserInfoContainAsterisk() {
        this.uri = "sqlserver://user*name:dd*dd@127.0.0.1:1234/dbname";
        this.actualParsedResult = MSSQLConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("user", (Object)"user*name").put("password", (Object)"dd*dd").put("host", (Object)"127.0.0.1").put("port", (Object)1234).put("database", (Object)"dbname");
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test
    public void testParsingSchemaContainAsterisk() {
        this.uri = "sqlserver://username:dddd@127.0.0.1:1234/*dbname";
        this.actualParsedResult = MSSQLConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("user", (Object)"username").put("password", (Object)"dddd").put("host", (Object)"127.0.0.1").put("port", (Object)1234).put("database", (Object)"*dbname");
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test
    public void testPartialMatching() {
        this.uri = "not_sqlserver://username:dddd@127.0.0.1:1234/*dbname";
        this.actualParsedResult = MSSQLConnectionUriParser.parse((String)this.uri, (boolean)false);
        Assert.assertNull((Object)this.actualParsedResult);
    }
}

