/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.data;

import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.mssqlclient.data.MSSQLDataTypeTestBase;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class MSSQLSmallDateTimeDataTypeTest
extends MSSQLDataTypeTestBase {
    private static final int minutes = 33;
    private static final List<Integer> seconds = Arrays.asList(0, 29, 30, 59);

    @Test
    public void testQueryTime(TestContext ctx) {
        LocalDateTime localDateTime = LocalDateTime.of(2021, 3, 26, 8, 33, 0);
        for (Integer second : seconds) {
            String columnName = String.format("test_smalldatetime_%d", second);
            int roundedUpMinute = (int)Math.floor((double)second.intValue() / 30.0);
            LocalDateTime expected = localDateTime.withSecond(0).withMinute(33 + roundedUpMinute);
            String value = String.format("'%s'", localDateTime.withSecond(second).toString().replace('T', ' '));
            this.testQueryDecodeGenericWithoutTable(ctx, columnName, "SMALLDATETIME", value, expected);
        }
    }

    @Test
    public void testPreparedQueryTime(TestContext ctx) {
        LocalDateTime localDateTime = LocalDateTime.of(2021, 3, 26, 8, 33, 0);
        for (Integer second : seconds) {
            String columnName = String.format("test_smalldatetime_%d", second);
            int roundedUpMinute = (int)Math.floor((double)second.intValue() / 30.0);
            LocalDateTime expected = localDateTime.withSecond(0).withMinute(33 + roundedUpMinute);
            String value = String.format("'%s'", localDateTime.withSecond(second).toString().replace('T', ' '));
            this.testPreparedQueryDecodeGenericWithoutTable(ctx, columnName, "SMALLDATETIME", value, expected);
        }
    }
}

