/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.mssqlclient.MSSQLConnectOptions;
import io.vertx.mssqlclient.MSSQLConnection;
import io.vertx.mssqlclient.MSSQLTestBase;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.Tuple;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class MSSQLMultipleTdsPacketsTest
extends MSSQLTestBase {
    Vertx vertx;
    MSSQLConnection connection;

    @Before
    public void setup(TestContext ctx) {
        this.vertx = Vertx.vertx();
        options = new MSSQLConnectOptions(MSSQLTestBase.options);
        MSSQLConnection.connect((Vertx)this.vertx, (MSSQLConnectOptions)options, (Handler)ctx.asyncAssertSuccess(conn -> {
            this.connection = conn;
        }));
    }

    @After
    public void tearDown(TestContext ctx) {
        if (this.connection != null) {
            this.connection.close(ctx.asyncAssertSuccess());
        }
        this.vertx.close(ctx.asyncAssertSuccess());
    }

    @Test
    public void testLargeBatch(TestContext ctx) {
        List batch = IntStream.range(0, 100).mapToObj(i -> Tuple.of((Object)UUID.randomUUID().toString())).collect(Collectors.toList());
        this.connection.query("TRUNCATE TABLE EntityWithIdentity").execute(ctx.asyncAssertSuccess(truncate -> this.connection.preparedQuery("INSERT INTO EntityWithIdentity (name) OUTPUT INSERTED.id, INSERTED.name VALUES (@p1)").executeBatch(batch, ctx.asyncAssertSuccess(result -> {
            for (Tuple tuple : batch) {
                Row row = (Row)result.iterator().next();
                ctx.assertNotNull((Object)row.getInteger("id"));
                ctx.assertEquals((Object)tuple.getString(0), (Object)row.getString("name"));
                result = result.next();
            }
            ctx.assertNull(result);
        }))));
    }
}

