/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient;

import io.vertx.mssqlclient.MSSQLException;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class MSSQLExceptionTest {
    private int number;
    private byte databaseState;
    private String expectedSqlCode;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({8152, 1, "22001"}, {515, 1, "23000"}, {547, 1, "23000"}, {2601, 1, "23000"}, {2627, 1, "23000"}, {2714, 1, "S0001"}, {208, 1, "S0002"}, {1205, 1, "40001"}, {-100, 54, "S0054"}, {0, 5, "S0005"}, {0, 127, "S0127"}, {0, 0, "S0000"});
    }

    public MSSQLExceptionTest(int vendorCode, int state, String sqlStateCode) {
        this.number = vendorCode;
        this.databaseState = (byte)state;
        this.expectedSqlCode = sqlStateCode;
    }

    @Test
    public void testSqlStateCodes() {
        MSSQLException mssqlException = new MSSQLException(this.number, this.databaseState, 0, null, null, null, 1);
        Assert.assertEquals((Object)this.expectedSqlCode, (Object)mssqlException.getSqlState());
        Assert.assertEquals((long)this.number, (long)mssqlException.getErrorCode());
    }
}

