/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.tck;

import io.vertx.core.Vertx;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.mssqlclient.MSSQLConnectOptions;
import io.vertx.mssqlclient.MSSQLPool;
import io.vertx.mssqlclient.junit.MSSQLRule;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.tck.TransactionTestBase;
import org.junit.AssumptionViolatedException;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class MSSQLTransactionTest
extends TransactionTestBase {
    @ClassRule
    public static MSSQLRule rule = MSSQLRule.SHARED_INSTANCE;

    protected Pool createPool() {
        return MSSQLPool.pool((Vertx)this.vertx, (MSSQLConnectOptions)new MSSQLConnectOptions(rule.options()), (PoolOptions)new PoolOptions().setMaxSize(1));
    }

    protected Pool nonTxPool() {
        return MSSQLPool.pool((Vertx)this.vertx, (MSSQLConnectOptions)new MSSQLConnectOptions(rule.options()), (PoolOptions)new PoolOptions().setMaxSize(1));
    }

    protected String statement(String ... parts) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            if (i > 0) {
                sb.append("@p").append(i);
            }
            sb.append(parts[i]);
        }
        return sb.toString();
    }

    @Test
    public void testDelayedCommit(TestContext ctx) {
        throw new AssumptionViolatedException("MSSQL holds write locks on inserted row with isolation level = 2");
    }
}

