/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.data;

import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.mssqlclient.data.MSSQLDataTypeTestBase;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class MSSQLDateTimeOffsetDataTypeTest
extends MSSQLDataTypeTestBase {
    private static final int[] HUNDRED_NANOS = new int[]{0, 1000000, 1100000, 1110000, 1111000, 1111100, 1111110, 1111111};

    @Test
    public void testQueryTime(TestContext ctx) {
        LocalDateTime localDateTime = LocalDateTime.of(2021, 3, 26, 8, 33, 21, 100 * HUNDRED_NANOS[7]);
        for (int i = 0; i <= 7; ++i) {
            String columnName = String.format("test_datetimeoffset_%d", i);
            String type = String.format("DATETIMEOFFSET(%d)", i);
            ZoneOffset offset = ZoneOffset.ofTotalSeconds(-7200 + i * 1800);
            OffsetDateTime offsetDateTime = localDateTime.atOffset(offset);
            String value = String.format("'%s'", offsetDateTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
            OffsetDateTime expected = localDateTime.withNano(100 * HUNDRED_NANOS[i]).atOffset(offset);
            this.testQueryDecodeGenericWithoutTable(ctx, columnName, type, value, expected);
        }
    }

    @Test
    public void testPreparedQueryTime(TestContext ctx) {
        LocalDateTime localDateTime = LocalDateTime.of(2021, 3, 26, 8, 33, 21, 100 * HUNDRED_NANOS[7]);
        for (int i = 0; i <= 7; ++i) {
            String columnName = String.format("test_datetimeoffset_%d", i);
            String type = String.format("DATETIMEOFFSET(%d)", i);
            ZoneOffset offset = ZoneOffset.ofTotalSeconds(-7200 + i * 1800);
            OffsetDateTime offsetDateTime = localDateTime.atOffset(offset);
            String value = String.format("'%s'", offsetDateTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
            OffsetDateTime expected = localDateTime.withNano(100 * HUNDRED_NANOS[i]).atOffset(offset);
            this.testPreparedQueryDecodeGenericWithoutTable(ctx, columnName, type, value, expected);
        }
    }
}

