package io.vertx.mssqlclient;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.impl.JsonUtil;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Base64;

/**
 * Converter and mapper for {@link io.vertx.mssqlclient.MSSQLInfo}.
 * NOTE: This class has been automatically generated from the {@link io.vertx.mssqlclient.MSSQLInfo} original class using Vert.x codegen.
 */
public class MSSQLInfoConverter {


  private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
  private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

  public static void fromJson(Iterable<java.util.Map.Entry<String, Object>> json, MSSQLInfo obj) {
    for (java.util.Map.Entry<String, Object> member : json) {
      switch (member.getKey()) {
        case "lineNumber":
          if (member.getValue() instanceof Number) {
            obj.setLineNumber(((Number)member.getValue()).intValue());
          }
          break;
        case "message":
          if (member.getValue() instanceof String) {
            obj.setMessage((String)member.getValue());
          }
          break;
        case "number":
          if (member.getValue() instanceof Number) {
            obj.setNumber(((Number)member.getValue()).intValue());
          }
          break;
        case "procedureName":
          if (member.getValue() instanceof String) {
            obj.setProcedureName((String)member.getValue());
          }
          break;
        case "serverName":
          if (member.getValue() instanceof String) {
            obj.setServerName((String)member.getValue());
          }
          break;
        case "severity":
          if (member.getValue() instanceof Number) {
            obj.setSeverity(((Number)member.getValue()).byteValue());
          }
          break;
        case "state":
          if (member.getValue() instanceof Number) {
            obj.setState(((Number)member.getValue()).byteValue());
          }
          break;
      }
    }
  }

  public static void toJson(MSSQLInfo obj, JsonObject json) {
    toJson(obj, json.getMap());
  }

  public static void toJson(MSSQLInfo obj, java.util.Map<String, Object> json) {
    json.put("lineNumber", obj.getLineNumber());
    if (obj.getMessage() != null) {
      json.put("message", obj.getMessage());
    }
    json.put("number", obj.getNumber());
    if (obj.getProcedureName() != null) {
      json.put("procedureName", obj.getProcedureName());
    }
    if (obj.getServerName() != null) {
      json.put("serverName", obj.getServerName());
    }
    json.put("severity", obj.getSeverity());
    json.put("state", obj.getState());
  }
}
