/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.tck;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.mssqlclient.MSSQLConnectOptions;
import io.vertx.mssqlclient.MSSQLConnection;
import io.vertx.mssqlclient.MSSQLPool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlClient;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.tck.Connector;

public enum ClientConfig {
    CONNECT{

        Connector<SqlConnection> connect(final Vertx vertx, final SqlConnectOptions options) {
            return new Connector<SqlConnection>(){

                public void connect(Handler<AsyncResult<SqlConnection>> handler) {
                    MSSQLConnectOptions connectOptions = new MSSQLConnectOptions(options);
                    MSSQLConnection.connect((Vertx)vertx, (MSSQLConnectOptions)connectOptions, ar -> {
                        if (ar.succeeded()) {
                            handler.handle((Object)Future.succeededFuture((Object)ar.result()));
                        } else {
                            handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                        }
                    });
                }

                public void close() {
                }
            };
        }
    }
    ,
    POOLED{

        Connector<SqlClient> connect(Vertx vertx, SqlConnectOptions options) {
            final MSSQLPool pool = MSSQLPool.pool((Vertx)vertx, (MSSQLConnectOptions)new MSSQLConnectOptions(options), (PoolOptions)new PoolOptions().setMaxSize(1));
            return new Connector<SqlClient>(){

                public void connect(Handler<AsyncResult<SqlClient>> handler) {
                    pool.getConnection(ar -> {
                        if (ar.succeeded()) {
                            handler.handle((Object)Future.succeededFuture((Object)ar.result()));
                        } else {
                            handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                        }
                    });
                }

                public void close() {
                    pool.close();
                }
            };
        }
    };


    abstract <C extends SqlClient> Connector<C> connect(Vertx var1, SqlConnectOptions var2);
}

