/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.junit;

import io.vertx.core.impl.Arguments;
import io.vertx.mssqlclient.MSSQLConnectOptions;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.ZoneId;
import org.junit.rules.ExternalResource;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.InternetProtocol;
import org.testcontainers.containers.MSSQLServerContainer;

public class MSSQLRule
extends ExternalResource {
    public static final MSSQLRule SHARED_INSTANCE = new MSSQLRule(false, false);
    private final boolean tls;
    private final boolean forceEncryption;
    private ServerContainer<?> server;
    private MSSQLConnectOptions options;
    private Path conf;

    public MSSQLRule(boolean tls, boolean forceEncryption) {
        Arguments.require((!forceEncryption || tls ? 1 : 0) != 0, (String)"Cannot force encryption without TLS support");
        this.tls = tls;
        this.forceEncryption = forceEncryption;
    }

    protected void before() throws IOException {
        String connectionUri = System.getProperty("connection.uri");
        if (!this.isNullOrEmpty(connectionUri)) {
            this.options = MSSQLConnectOptions.fromUri((String)connectionUri);
        } else if (this.server == null) {
            this.options = this.startMSSQL();
        }
    }

    private boolean isNullOrEmpty(String connectionUri) {
        return connectionUri == null || connectionUri.isEmpty();
    }

    protected void after() {
        if (this.isNullOrEmpty(System.getProperty("connection.uri")) || this != SHARED_INSTANCE) {
            this.stopMSSQL();
        }
    }

    private MSSQLConnectOptions startMSSQL() throws IOException {
        String containerVersion = System.getProperty("mssql-container.version");
        if (containerVersion == null || containerVersion.isEmpty()) {
            containerVersion = "2017-latest";
        }
        this.server = (ServerContainer)((ServerContainer)((ServerContainer)new ServerContainer("mcr.microsoft.com/mssql/server:" + containerVersion).acceptLicense()).withEnv("TZ", ZoneId.systemDefault().toString())).withInitScript("init.sql");
        if (System.getProperties().containsKey("containerFixedPort")) {
            this.server.withFixedExposedPort(MSSQLServerContainer.MS_SQL_SERVER_PORT, MSSQLServerContainer.MS_SQL_SERVER_PORT);
        } else {
            this.server.withExposedPorts(new Integer[]{MSSQLServerContainer.MS_SQL_SERVER_PORT});
        }
        if (this.tls) {
            this.conf = this.createConf();
            ((ServerContainer)((ServerContainer)this.server.withFileSystemBind(this.conf.toAbsolutePath().toString(), "/var/opt/mssql/mssql.conf", BindMode.READ_ONLY)).withClasspathResourceMapping("mssql.key", "/etc/ssl/certs/mssql.key", BindMode.READ_ONLY)).withClasspathResourceMapping("mssql.pem", "/etc/ssl/certs/mssql.pem", BindMode.READ_ONLY);
        }
        this.server.start();
        return new MSSQLConnectOptions().setHost(this.server.getContainerIpAddress()).setPort(this.server.getMappedPort(MSSQLServerContainer.MS_SQL_SERVER_PORT).intValue()).setUser(this.server.getUsername()).setPassword(this.server.getPassword());
    }

    private Path createConf() throws IOException {
        Path path = Files.createTempFile("mssql.conf", null, new FileAttribute[0]);
        URL resource = ((Object)((Object)this)).getClass().getClassLoader().getResource("mssql.conf");
        try (InputStream is = resource.openStream();){
            Files.copy(is, path, StandardCopyOption.REPLACE_EXISTING);
        }
        if (this.forceEncryption) {
            Files.write(path, "forceencryption = 1".getBytes(StandardCharsets.UTF_8), StandardOpenOption.WRITE, StandardOpenOption.APPEND);
        }
        return path;
    }

    private void stopMSSQL() {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            finally {
                this.server = null;
            }
        }
        if (this.conf != null) {
            try {
                Files.delete(this.conf);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public MSSQLConnectOptions options() {
        return new MSSQLConnectOptions(this.options);
    }

    private static class ServerContainer<SELF extends ServerContainer<SELF>>
    extends MSSQLServerContainer<SELF> {
        public ServerContainer(String dockerImageName) {
            super(dockerImageName);
        }

        public SELF withFixedExposedPort(int hostPort, int containerPort) {
            super.addFixedExposedPort(hostPort, containerPort, InternetProtocol.TCP);
            return (SELF)((Object)((ServerContainer)this.self()));
        }
    }
}

