/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.data;

import io.vertx.core.buffer.Buffer;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.Repeat;
import io.vertx.ext.unit.junit.RepeatRule;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.mssqlclient.data.MSSQLNotNullableDataTypeTestBase;
import io.vertx.sqlclient.ColumnChecker;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.Tuple;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class MSSQLPreparedQueryNotNullableDataTypeTest
extends MSSQLNotNullableDataTypeTestBase {
    @Rule
    public RepeatRule rule = new RepeatRule();

    @Test
    public void testEncodeTinyInt(TestContext ctx) {
        this.testEncodeNumber(ctx, "test_tinyint", (short)255);
    }

    @Test
    public void testEncodeSmallInt(TestContext ctx) {
        this.testEncodeNumber(ctx, "test_smallint", (short)Short.MIN_VALUE);
    }

    @Test
    public void testEncodeInt(TestContext ctx) {
        this.testEncodeNumber(ctx, "test_int", Integer.MIN_VALUE);
    }

    @Test
    public void testEncodeBigInt(TestContext ctx) {
        this.testEncodeNumber(ctx, "test_bigint", Long.MIN_VALUE);
    }

    @Test
    public void testEncodeFloat4(TestContext ctx) {
        this.testEncodeNumber(ctx, "test_float_4", Float.valueOf(-3.40282E38f));
    }

    @Test
    public void testEncodeFloat8(TestContext ctx) {
        this.testEncodeNumber(ctx, "test_float_8", -1.7976931348623157E308);
    }

    @Test
    public void testEncodeNumeric(TestContext ctx) {
        this.testEncodeNumber(ctx, "test_numeric", new BigDecimal("-123.13"));
    }

    @Test
    public void testEncodeDecimal(TestContext ctx) {
        this.testEncodeNumber(ctx, "test_decimal", new BigDecimal("123456789"));
    }

    @Test
    public void testEncodeBit(TestContext ctx) {
        this.testPreparedQueryEncodeGeneric(ctx, "not_nullable_datatype", "test_boolean", false, row -> ColumnChecker.checkColumn((int)0, (String)"test_boolean").returns(Tuple::getValue, Row::getValue, (Object)false).returns(Tuple::getBoolean, Row::getBoolean, (Object)false).returns(Boolean.class, (Object)false).forRow(row));
    }

    @Test
    public void testEncodeChar(TestContext ctx) {
        this.testPreparedQueryEncodeGeneric(ctx, "not_nullable_datatype", "test_char", "chartest", row -> ColumnChecker.checkColumn((int)0, (String)"test_char").returns(Tuple::getValue, Row::getValue, (Object)"chartest").returns(Tuple::getString, Row::getString, (Object)"chartest").returns(String.class, (Object)"chartest").forRow(row));
    }

    @Test
    public void testEncodeVarChar(TestContext ctx) {
        this.testPreparedQueryEncodeGeneric(ctx, "not_nullable_datatype", "test_varchar", "testedvarchar", row -> ColumnChecker.checkColumn((int)0, (String)"test_varchar").returns(Tuple::getValue, Row::getValue, (Object)"testedvarchar").returns(Tuple::getString, Row::getString, (Object)"testedvarchar").returns(String.class, (Object)"testedvarchar").forRow(row));
    }

    @Test
    public void testEncodeDate(TestContext ctx) {
        this.testPreparedQueryEncodeGeneric(ctx, "not_nullable_datatype", "test_date", LocalDate.of(1999, 12, 31), row -> ColumnChecker.checkColumn((int)0, (String)"test_date").returns(Tuple::getValue, Row::getValue, (Object)LocalDate.of(1999, 12, 31)).returns(Tuple::getLocalDate, Row::getLocalDate, (Object)LocalDate.of(1999, 12, 31)).returns(LocalDate.class, (Object)LocalDate.of(1999, 12, 31)).forRow(row));
    }

    @Test
    @Repeat(value=100)
    public void testEncodeTime(TestContext ctx) {
        int nanoOfSecond = 1000 * ThreadLocalRandom.current().nextInt(1000000);
        LocalTime now = LocalTime.now().withNano(nanoOfSecond);
        this.testPreparedQueryEncodeGeneric(ctx, "not_nullable_datatype", "test_time", now, row -> ColumnChecker.checkColumn((int)0, (String)"test_time").returns(Tuple::getValue, Row::getValue, (Object)now).returns(Tuple::getLocalTime, Row::getLocalTime, (Object)now).returns(LocalTime.class, (Object)now).forRow(row));
    }

    @Test
    @Repeat(value=100)
    public void testEncodeSmallDateTime(TestContext ctx) {
        LocalDateTime now = LocalDateTime.now();
        int roundedUpMinute = (int)Math.floor((double)now.getSecond() / 30.0);
        LocalDateTime convertedNow = now.withSecond(0).withNano(0).withMinute(now.getMinute() + roundedUpMinute);
        this.testPreparedQueryEncodeGeneric(ctx, "not_nullable_datatype", "test_smalldatetime", now, row -> ColumnChecker.checkColumn((int)0, (String)"test_smalldatetime").returns(Tuple::getValue, Row::getValue, (Object)convertedNow).returns(Tuple::getLocalDateTime, Row::getLocalDateTime, (Object)convertedNow).returns(Tuple::getLocalDate, Row::getLocalDate, (Object)convertedNow.toLocalDate()).returns(Tuple::getLocalTime, Row::getLocalTime, (Object)convertedNow.toLocalTime()).returns(LocalDateTime.class, (Object)convertedNow).forRow(row));
    }

    @Test
    @Repeat(value=100)
    public void testEncodeDateTime(TestContext ctx) {
        int nanosPerSecond = 1000000000;
        LocalDateTime now = LocalDateTime.now();
        int nanoOfDay = (int)Math.round((double)Math.round((double)now.getNano() / 1000000.0 / 3.333333) * 3.333333) * 1000000;
        int secondOfDay = now.getSecond();
        if (nanoOfDay == 1000000000) {
            nanoOfDay = 0;
            ++secondOfDay;
        }
        LocalDateTime convertedNow = now.withNano(nanoOfDay).withSecond(secondOfDay);
        this.testPreparedQueryEncodeGeneric(ctx, "not_nullable_datatype", "test_datetime", now, row -> ColumnChecker.checkColumn((int)0, (String)"test_datetime").returns(Tuple::getValue, Row::getValue, (Object)convertedNow).returns(Tuple::getLocalDateTime, Row::getLocalDateTime, (Object)convertedNow).returns(Tuple::getLocalDate, Row::getLocalDate, (Object)convertedNow.toLocalDate()).returns(Tuple::getLocalTime, Row::getLocalTime, (Object)convertedNow.toLocalTime()).returns(LocalDateTime.class, (Object)convertedNow).forRow(row));
    }

    @Test
    @Repeat(value=100)
    public void testEncodeDateTime2(TestContext ctx) {
        int nanoOfSecond = 100 * ThreadLocalRandom.current().nextInt(10000000);
        LocalDateTime now = LocalDateTime.now().withNano(nanoOfSecond);
        this.testPreparedQueryEncodeGeneric(ctx, "not_nullable_datatype", "test_datetime2", now, row -> ColumnChecker.checkColumn((int)0, (String)"test_datetime2").returns(Tuple::getValue, Row::getValue, (Object)now).returns(Tuple::getLocalDateTime, Row::getLocalDateTime, (Object)now).returns(Tuple::getLocalDate, Row::getLocalDate, (Object)now.toLocalDate()).returns(Tuple::getLocalTime, Row::getLocalTime, (Object)now.toLocalTime()).returns(LocalDateTime.class, (Object)now).forRow(row));
    }

    @Test
    @Repeat(value=100)
    public void testEncodeOffsetDateTime(TestContext ctx) {
        int nanoOfSecond = ThreadLocalRandom.current().nextInt(100000) * 10000;
        OffsetDateTime now = LocalDateTime.now().withNano(nanoOfSecond).atOffset(ZoneOffset.ofHoursMinutes(-3, -15));
        this.testPreparedQueryEncodeGeneric(ctx, "not_nullable_datatype", "test_datetimeoffset", now, row -> ColumnChecker.checkColumn((int)0, (String)"test_datetimeoffset").returns(Tuple::getValue, Row::getValue, (Object)now).returns(Tuple::getOffsetDateTime, Row::getOffsetDateTime, (Object)now).returns(Tuple::getLocalDateTime, Row::getLocalDateTime, (Object)now.toLocalDateTime()).returns(Tuple::getLocalDate, Row::getLocalDate, (Object)now.toLocalDate()).returns(Tuple::getLocalTime, Row::getLocalTime, (Object)now.toLocalTime()).returns(OffsetDateTime.class, (Object)now).forRow(row));
    }

    @Test
    public void testEncodeBinary(TestContext ctx) {
        String str = "john doe";
        Buffer param = Buffer.buffer((String)str);
        Buffer expected = Buffer.buffer((String)str).appendBytes(new byte[20 - str.length()]);
        this.testPreparedQueryEncodeGeneric(ctx, "not_nullable_datatype", "test_binary", param, row -> ColumnChecker.checkColumn((int)0, (String)"test_binary").returns(Tuple::getValue, Row::getValue, (Object)expected).returns(Tuple::getBuffer, Row::getBuffer, (Object)expected).returns(Buffer.class, (Object)expected).forRow(row));
    }

    @Test
    public void testEncodeVarBinary(TestContext ctx) {
        this.testPreparedQueryEncodeGeneric(ctx, "not_nullable_datatype", "test_varbinary", Buffer.buffer((String)"ninja plumber"), row -> ColumnChecker.checkColumn((int)0, (String)"test_varbinary").returns(Tuple::getValue, Row::getValue, (Object)Buffer.buffer((String)"ninja plumber")).returns(Tuple::getBuffer, Row::getBuffer, (Object)Buffer.buffer((String)"ninja plumber")).returns(Buffer.class, (Object)Buffer.buffer((String)"ninja plumber")).forRow(row));
    }

    @Test
    public void testEncodeMoney(TestContext ctx) {
        this.testPreparedQueryEncodeGeneric(ctx, "not_nullable_datatype", "test_money", "\u20ac12.1234", row -> MSSQLPreparedQueryNotNullableDataTypeTest.checkNumber(row, "test_money", new BigDecimal("12.1234")));
    }

    @Test
    public void testEncodeSmallMoney(TestContext ctx) {
        this.testPreparedQueryEncodeGeneric(ctx, "not_nullable_datatype", "test_smallmoney", "\u20ac12.12", row -> MSSQLPreparedQueryNotNullableDataTypeTest.checkNumber(row, "test_smallmoney", new BigDecimal("12.12")));
    }

    @Override
    protected void testDecodeValue(TestContext ctx, boolean isNull, String columnName, Consumer<Row> checker) {
        this.testPreparedQueryDecodeGeneric(ctx, "not_nullable_datatype", columnName, "1", checker);
    }

    private void testEncodeNumber(TestContext ctx, String columnName, Number value) {
        this.testPreparedQueryEncodeGeneric(ctx, "not_nullable_datatype", columnName, value, row -> MSSQLPreparedQueryNotNullableDataTypeTest.checkNumber(row, columnName, value));
    }
}

