/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.ext.unit.TestContext;
import io.vertx.mssqlclient.MSSQLConnectOptions;
import io.vertx.mssqlclient.MSSQLConnection;
import io.vertx.mssqlclient.junit.MSSQLRule;
import io.vertx.sqlclient.Row;
import javax.net.ssl.SSLHandshakeException;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public abstract class MSSQLEncryptionTestBase {
    protected Vertx vertx;
    private MSSQLConnectOptions options;
    private MSSQLConnection connection;

    protected abstract MSSQLRule rule();

    protected void setOptions(MSSQLConnectOptions options) {
        this.options = options;
    }

    @Before
    public void setup() {
        this.vertx = Vertx.vertx();
    }

    @After
    public void tearDown(TestContext ctx) {
        if (this.connection != null) {
            this.connection.close(ctx.asyncAssertSuccess());
        }
        this.vertx.close(ctx.asyncAssertSuccess());
    }

    protected void connect(Handler<AsyncResult<MSSQLConnection>> handler) {
        MSSQLConnection.connect((Vertx)this.vertx, (MSSQLConnectOptions)this.options).onSuccess(conn -> {
            this.connection = conn;
        }).onComplete(handler);
    }

    protected void asyncAssertConnectionEncrypted(TestContext ctx) {
        this.asyncAssertConnectionEncrypted(ctx, true);
    }

    protected void asyncAssertConnectionUnencrypted(TestContext ctx) {
        this.asyncAssertConnectionEncrypted(ctx, false);
    }

    private void asyncAssertConnectionEncrypted(TestContext ctx, boolean expected) {
        this.connect((Handler<AsyncResult<MSSQLConnection>>)ctx.asyncAssertSuccess(conn -> conn.query("SELECT encrypt_option FROM sys.dm_exec_connections WHERE session_id = @@SPID").execute(ctx.asyncAssertSuccess(rows -> {
            ctx.assertEquals((Object)1, (Object)rows.size());
            ctx.assertEquals((Object)expected, (Object)Boolean.parseBoolean(((Row)rows.iterator().next()).getString("encrypt_option")));
        }))));
    }

    @Test
    public void testHostnameValidationFails(TestContext ctx) {
        this.setOptions(this.rule().options().setSsl(true));
        this.connect((Handler<AsyncResult<MSSQLConnection>>)ctx.asyncAssertFailure(t -> ctx.assertTrue(t instanceof SSLHandshakeException)));
    }

    @Test
    public void testTrustAll(TestContext ctx) {
        this.setOptions(this.rule().options().setSsl(true).setTrustAll(true));
        this.asyncAssertConnectionEncrypted(ctx);
    }

    @Test
    public void testTrustOptions(TestContext ctx) {
        Buffer certValue = this.vertx.fileSystem().readFileBlocking("mssql.pem");
        this.setOptions(this.rule().options().setSsl(true).setPemTrustOptions(new PemTrustOptions().addCertValue(certValue)));
        this.asyncAssertConnectionEncrypted(ctx);
    }
}

