/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.vertx.mssqlclient.impl.codec.MSSQLCommandCodec;
import io.vertx.mssqlclient.impl.codec.TdsMessageEncoder;
import io.vertx.mssqlclient.impl.protocol.MessageStatus;
import io.vertx.mssqlclient.impl.protocol.TdsMessage;
import io.vertx.mssqlclient.impl.protocol.TdsPacket;
import io.vertx.sqlclient.impl.command.CommandResponse;
import java.util.ArrayDeque;
import java.util.Iterator;

class TdsMessageDecoder
extends ChannelInboundHandlerAdapter {
    private final ArrayDeque<MSSQLCommandCodec<?, ?>> inflight;
    private final TdsMessageEncoder encoder;
    private TdsMessage message;

    TdsMessageDecoder(ArrayDeque<MSSQLCommandCodec<?, ?>> inflight, TdsMessageEncoder encoder) {
        this.inflight = inflight;
        this.encoder = encoder;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        TdsPacket tdsPacket = (TdsPacket)((Object)msg);
        if (tdsPacket.status() == MessageStatus.END_OF_MESSAGE) {
            if (this.message == null) {
                this.message = TdsMessage.newTdsMessageFromSinglePacket(tdsPacket);
            } else {
                CompositeByteBuf messageData = (CompositeByteBuf)this.message.content();
                messageData.addComponent(true, tdsPacket.content());
            }
            this.decodeMessage();
        } else if (this.message == null) {
            CompositeByteBuf messageData = ctx.alloc().compositeDirectBuffer();
            messageData.addComponent(true, tdsPacket.content());
            this.message = TdsMessage.newTdsMessage(tdsPacket.type(), tdsPacket.status(), tdsPacket.processId(), (ByteBuf)messageData);
        } else {
            CompositeByteBuf messageData = (CompositeByteBuf)this.message.content();
            messageData.addComponent(true, tdsPacket.content());
        }
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.releaseMessage();
    }

    private void releaseMessage() {
        if (this.message != null) {
            this.message.release();
            this.message = null;
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.clearInflightCommands(ctx, "Fail to read any response from the server, the underlying connection might get lost unexpectedly.");
        super.channelInactive(ctx);
    }

    private void decodeMessage() {
        try {
            this.inflight.peek().decodeMessage(this.message, this.encoder);
        }
        finally {
            this.releaseMessage();
        }
    }

    private void clearInflightCommands(ChannelHandlerContext ctx, String failureMsg) {
        Iterator<MSSQLCommandCodec<?, ?>> it = this.inflight.iterator();
        while (it.hasNext()) {
            MSSQLCommandCodec<?, ?> codec = it.next();
            it.remove();
            CommandResponse failure = CommandResponse.failure((String)failureMsg);
            failure.cmd = codec.cmd;
            ctx.fireChannelRead((Object)failure);
        }
    }
}

