/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.vertx.mssqlclient.impl.codec.MSSQLRowDesc;
import io.vertx.mssqlclient.impl.codec.QueryCommandBaseCodec;
import io.vertx.mssqlclient.impl.codec.RowResultDecoder;
import io.vertx.mssqlclient.impl.codec.TdsMessageEncoder;
import io.vertx.mssqlclient.impl.protocol.MessageStatus;
import io.vertx.mssqlclient.impl.protocol.MessageType;
import io.vertx.mssqlclient.impl.protocol.TdsMessage;
import io.vertx.mssqlclient.impl.protocol.token.DataPacketStreamTokenType;
import io.vertx.sqlclient.impl.command.SimpleQueryCommand;
import java.nio.charset.StandardCharsets;

class SQLBatchCommandCodec<T>
extends QueryCommandBaseCodec<T, SimpleQueryCommand<T>> {
    SQLBatchCommandCodec(SimpleQueryCommand cmd) {
        super(cmd);
    }

    @Override
    void encode(TdsMessageEncoder encoder) {
        super.encode(encoder);
        this.sendBatchClientRequest();
    }

    @Override
    void decodeMessage(TdsMessage message, TdsMessageEncoder encoder) {
        ByteBuf messageBody = message.content();
        block9: while (messageBody.isReadable()) {
            DataPacketStreamTokenType tokenType = DataPacketStreamTokenType.valueOf(messageBody.readUnsignedByte());
            if (tokenType == null) {
                throw new UnsupportedOperationException("Unsupported token: " + (Object)((Object)tokenType));
            }
            switch (tokenType) {
                case COLMETADATA_TOKEN: {
                    MSSQLRowDesc rowDesc = this.decodeColmetadataToken(messageBody);
                    this.rowResultDecoder = new RowResultDecoder(((SimpleQueryCommand)this.cmd).collector(), rowDesc);
                    continue block9;
                }
                case ROW_TOKEN: {
                    this.handleRow(messageBody);
                    continue block9;
                }
                case NBCROW_TOKEN: {
                    this.handleNbcRow(messageBody);
                    continue block9;
                }
                case DONE_TOKEN: 
                case DONEPROC_TOKEN: {
                    short status = messageBody.readShortLE();
                    short curCmd = messageBody.readShortLE();
                    long doneRowCount = messageBody.readLongLE();
                    this.handleResultSetDone((int)doneRowCount);
                    continue block9;
                }
                case INFO_TOKEN: 
                case ORDER_TOKEN: {
                    int tokenLength = messageBody.readUnsignedShortLE();
                    messageBody.skipBytes(tokenLength);
                    continue block9;
                }
                case ERROR_TOKEN: {
                    this.handleErrorToken(messageBody);
                    continue block9;
                }
                case ENVCHANGE_TOKEN: {
                    this.handleEnvChangeToken(messageBody);
                    continue block9;
                }
            }
            throw new UnsupportedOperationException("Unsupported token: " + (Object)((Object)tokenType));
        }
        this.complete();
    }

    private void sendBatchClientRequest() {
        ChannelHandlerContext chctx = this.encoder.chctx;
        ByteBuf packet = chctx.alloc().ioBuffer();
        packet.writeByte(MessageType.SQL_BATCH.value());
        packet.writeByte(MessageStatus.NORMAL.value() | MessageStatus.END_OF_MESSAGE.value());
        int packetLenIdx = packet.writerIndex();
        packet.writeShort(0);
        packet.writeShort(0);
        packet.writeByte(0);
        packet.writeByte(0);
        int start = packet.writerIndex();
        packet.writeIntLE(0);
        this.encodeTransactionDescriptor(packet);
        packet.setIntLE(start, packet.writerIndex() - start);
        packet.writeCharSequence((CharSequence)((SimpleQueryCommand)this.cmd).sql(), StandardCharsets.UTF_16LE);
        int packetLen = packet.writerIndex() - packetLenIdx + 2;
        packet.setShort(packetLenIdx, packetLen);
        chctx.writeAndFlush((Object)packet, this.encoder.chctx.voidPromise());
    }
}

