/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.vertx.mssqlclient.impl.codec.MSSQLCommandCodec;
import io.vertx.mssqlclient.impl.codec.TdsMessageEncoder;
import io.vertx.mssqlclient.impl.command.PreLoginCommand;
import io.vertx.mssqlclient.impl.protocol.MessageStatus;
import io.vertx.mssqlclient.impl.protocol.MessageType;
import io.vertx.mssqlclient.impl.protocol.TdsMessage;
import io.vertx.mssqlclient.impl.protocol.client.prelogin.EncryptionOptionToken;
import io.vertx.mssqlclient.impl.protocol.client.prelogin.OptionToken;
import io.vertx.sqlclient.impl.command.CommandResponse;
import java.util.List;

class PreLoginCommandCodec
extends MSSQLCommandCodec<Void, PreLoginCommand> {
    PreLoginCommandCodec(PreLoginCommand cmd) {
        super(cmd);
    }

    @Override
    void encode(TdsMessageEncoder encoder) {
        super.encode(encoder);
        this.sendPreLoginMessage();
    }

    @Override
    void decodeMessage(TdsMessage message, TdsMessageEncoder encoder) {
        this.completionHandler.handle((Object)CommandResponse.success(null));
    }

    private void sendPreLoginMessage() {
        ChannelHandlerContext chctx = this.encoder.chctx;
        ByteBuf packet = chctx.alloc().ioBuffer();
        packet.writeByte(MessageType.PRE_LOGIN.value());
        packet.writeByte(MessageStatus.NORMAL.value() | MessageStatus.END_OF_MESSAGE.value());
        int packetLenIdx = packet.writerIndex();
        packet.writeShort(0);
        packet.writeShort(0);
        packet.writeByte(0);
        packet.writeByte(0);
        int packetDataStartIdx = packet.writerIndex();
        List<OptionToken> optionTokens = ((PreLoginCommand)this.cmd).optionTokens();
        int payloadStartIdx = packet.writerIndex();
        int totalLengthOfOptionsData = 0;
        int versionOptionTokenOffsetLengthIdx = 0;
        int encryptionOptionTokenOffsetLengthIdx = 0;
        for (OptionToken token : optionTokens) {
            totalLengthOfOptionsData += token.optionLength();
            packet.writeByte((int)token.tokenType());
            switch (token.tokenType()) {
                case 0: {
                    versionOptionTokenOffsetLengthIdx = packet.writerIndex();
                    break;
                }
                case 1: {
                    encryptionOptionTokenOffsetLengthIdx = packet.writerIndex();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected token type");
                }
            }
            packet.writeShort(0);
            packet.writeShort(token.optionLength());
        }
        packet.writeByte(255);
        for (OptionToken token : optionTokens) {
            this.encodeTokenData(token, packet);
        }
        int totalLengthOfPayload = packet.writerIndex() - payloadStartIdx;
        int offsetStart = totalLengthOfPayload - totalLengthOfOptionsData;
        block10: for (OptionToken token : optionTokens) {
            switch (token.tokenType()) {
                case 0: {
                    packet.setShort(versionOptionTokenOffsetLengthIdx, offsetStart);
                    offsetStart += token.optionLength();
                    continue block10;
                }
                case 1: {
                    packet.setShort(encryptionOptionTokenOffsetLengthIdx, offsetStart);
                    offsetStart += token.optionLength();
                    continue block10;
                }
            }
            throw new IllegalStateException("Unexpected token type");
        }
        int packetLen = packet.writerIndex() - packetDataStartIdx + 8;
        packet.setShort(packetLenIdx, packetLen);
        chctx.writeAndFlush((Object)packet, this.encoder.chctx.voidPromise());
    }

    private void encodeTokenData(OptionToken optionToken, ByteBuf payload) {
        switch (optionToken.tokenType()) {
            case 0: {
                payload.writeInt(0);
                payload.writeShort(0);
                break;
            }
            case 1: {
                payload.writeByte((int)((EncryptionOptionToken)optionToken).setting());
            }
        }
    }
}

