/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.vertx.core.buffer.Buffer;
import io.vertx.mssqlclient.impl.protocol.datatype.DateTime2NDataType;
import io.vertx.mssqlclient.impl.protocol.datatype.DateTimeOffsetNDataType;
import io.vertx.mssqlclient.impl.protocol.datatype.DecimalDataType;
import io.vertx.mssqlclient.impl.protocol.datatype.MSSQLDataType;
import io.vertx.mssqlclient.impl.protocol.datatype.TimeNDataType;
import io.vertx.sqlclient.data.NullValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

class MSSQLDataTypeCodec {
    static LocalDate START_DATE = LocalDate.of(1, 1, 1);
    static LocalDate START_DATE_DATETIME = LocalDate.of(1900, 1, 1);
    private static final Map<Class<?>, String> parameterDefinitionsMapping = new HashMap();

    MSSQLDataTypeCodec() {
    }

    static String inferenceParamDefinitionByValueType(Object value) {
        Class type;
        if (value == null) {
            return "nvarchar(4000)";
        }
        boolean nullValue = value instanceof NullValue;
        Class clazz = type = nullValue ? ((NullValue)value).type() : value.getClass();
        if (type == BigDecimal.class) {
            return "numeric(38," + (nullValue ? 0 : Math.max(0, ((BigDecimal)value).scale())) + ")";
        }
        if (Buffer.class.isAssignableFrom(type)) {
            return "binary(" + (nullValue ? 1 : ((Buffer)value).length()) + ")";
        }
        if (type.isEnum()) {
            return parameterDefinitionsMapping.get(String.class);
        }
        String paramDefinition = parameterDefinitionsMapping.get(type);
        if (paramDefinition != null) {
            return paramDefinition;
        }
        throw new UnsupportedOperationException("Unsupported type: " + type.getSimpleName());
    }

    static Object decode(MSSQLDataType dataType, ByteBuf in) {
        switch (dataType.id()) {
            case 48: {
                return MSSQLDataTypeCodec.decodeTinyInt(in);
            }
            case 52: {
                return MSSQLDataTypeCodec.decodeSmallInt(in);
            }
            case 56: {
                return MSSQLDataTypeCodec.decodeInt(in);
            }
            case 127: {
                return MSSQLDataTypeCodec.decodeBigInt(in);
            }
            case 106: 
            case 108: {
                return MSSQLDataTypeCodec.decodeDecimal((DecimalDataType)dataType, in);
            }
            case 38: {
                return MSSQLDataTypeCodec.decodeIntN(in);
            }
            case 59: {
                return Float.valueOf(MSSQLDataTypeCodec.decodeFloat4(in));
            }
            case 62: {
                return MSSQLDataTypeCodec.decodeFloat8(in);
            }
            case 109: {
                return MSSQLDataTypeCodec.decodeFltN(in);
            }
            case 50: {
                return MSSQLDataTypeCodec.decodeBit(in);
            }
            case 104: {
                return MSSQLDataTypeCodec.decodeBitN(in);
            }
            case 61: {
                return MSSQLDataTypeCodec.decodeDateTime(in);
            }
            case 40: {
                return MSSQLDataTypeCodec.decodeDateN(in);
            }
            case 41: {
                return MSSQLDataTypeCodec.decodeTimeN((TimeNDataType)dataType, in);
            }
            case 42: {
                return MSSQLDataTypeCodec.decodeDateTime2N((DateTime2NDataType)dataType, in);
            }
            case 43: {
                return MSSQLDataTypeCodec.decodeDateTimeOffsetN((DateTimeOffsetNDataType)dataType, in);
            }
            case 167: 
            case 175: {
                return MSSQLDataTypeCodec.decodeVarchar(in);
            }
            case 231: 
            case 239: {
                return MSSQLDataTypeCodec.decodeNVarchar(in);
            }
            case 37: 
            case 45: 
            case 165: 
            case 173: {
                return MSSQLDataTypeCodec.decodeBinary(in);
            }
        }
        throw new UnsupportedOperationException("Unsupported datatype: " + dataType);
    }

    private static LocalTime decodeTimeN(TimeNDataType dataType, ByteBuf in) {
        byte length = in.readByte();
        if (length == 0) {
            return null;
        }
        return MSSQLDataTypeCodec.decodeLocalTime(in, length, dataType.scale());
    }

    private static LocalTime decodeLocalTime(ByteBuf in, int length, int scale) {
        long hundredNanos;
        if (length == 3) {
            hundredNanos = in.readUnsignedMediumLE();
        } else if (length == 4) {
            hundredNanos = in.readUnsignedIntLE();
        } else if (length == 5) {
            hundredNanos = MSSQLDataTypeCodec.readUnsignedInt40LE(in);
        } else {
            throw new IllegalArgumentException("Unexpected timeLength of [" + length + "]");
        }
        for (int i = scale; i < 7; ++i) {
            hundredNanos *= 10L;
        }
        return LocalTime.ofNanoOfDay(100L * hundredNanos);
    }

    private static LocalDateTime decodeDateTime2N(DateTime2NDataType dataType, ByteBuf in) {
        byte length = in.readByte();
        if (length == 0) {
            return null;
        }
        LocalTime localTime = MSSQLDataTypeCodec.decodeLocalTime(in, length - 3, dataType.scale());
        LocalDate localDate = MSSQLDataTypeCodec.decodeLocalDate(in, 3);
        return LocalDateTime.of(localDate, localTime);
    }

    private static OffsetDateTime decodeDateTimeOffsetN(DateTimeOffsetNDataType dataType, ByteBuf in) {
        byte length = in.readByte();
        if (length == 0) {
            return null;
        }
        LocalTime localTime = MSSQLDataTypeCodec.decodeLocalTime(in, length - 5, dataType.scale());
        LocalDate localDate = MSSQLDataTypeCodec.decodeLocalDate(in, 3);
        short minutes = in.readShortLE();
        return LocalDateTime.of(localDate, localTime).plusMinutes(minutes).atOffset(ZoneOffset.ofTotalSeconds(60 * minutes));
    }

    private static CharSequence decodeNVarchar(ByteBuf in) {
        int length = in.readUnsignedShortLE();
        if (length == 65535) {
            return null;
        }
        return in.readCharSequence(length, StandardCharsets.UTF_16LE);
    }

    private static Buffer decodeBinary(ByteBuf in) {
        int length = in.readUnsignedShortLE();
        ByteBuf byteBuf = Unpooled.buffer((int)length);
        in.readBytes(byteBuf, 0, length);
        byteBuf.writerIndex(length);
        return Buffer.buffer((ByteBuf)byteBuf);
    }

    private static CharSequence decodeVarchar(ByteBuf in) {
        int length = in.readUnsignedShortLE();
        if (length == 65535) {
            return null;
        }
        return in.readCharSequence(length, StandardCharsets.UTF_8);
    }

    private static LocalDateTime decodeDateTime(ByteBuf in) {
        LocalDate localDate = START_DATE_DATETIME.plus(in.readIntLE(), ChronoUnit.DAYS);
        long nanoOfDay = TimeUnit.NANOSECONDS.convert(Math.round((double)in.readIntLE() * 3.3333333333333335), TimeUnit.MILLISECONDS);
        LocalTime localTime = LocalTime.ofNanoOfDay(nanoOfDay);
        return LocalDateTime.of(localDate, localTime);
    }

    private static LocalDate decodeDateN(ByteBuf in) {
        byte length = in.readByte();
        if (length == 0) {
            return null;
        }
        return MSSQLDataTypeCodec.decodeLocalDate(in, length);
    }

    private static LocalDate decodeLocalDate(ByteBuf in, int length) {
        if (length != 3) {
            throw new IllegalArgumentException("Unexpected dateLength of [" + length + "]");
        }
        int days = in.readUnsignedMediumLE();
        return START_DATE.plus(days, ChronoUnit.DAYS);
    }

    private static boolean decodeBit(ByteBuf in) {
        return in.readBoolean();
    }

    private static double decodeFloat8(ByteBuf in) {
        return in.readDoubleLE();
    }

    private static float decodeFloat4(ByteBuf in) {
        return in.readFloatLE();
    }

    private static BigDecimal decodeDecimal(DecimalDataType dataType, ByteBuf in) {
        int scale = dataType.scale();
        short length = in.readUnsignedByte();
        if (length == 0) {
            return null;
        }
        byte sign = in.readByte();
        byte[] bytes = new byte[length - 1];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = in.getByte(in.readerIndex() + bytes.length - 1 - i);
        }
        in.skipBytes(bytes.length);
        BigInteger bigInteger = new BigInteger(bytes);
        BigDecimal bigDecimal = new BigDecimal(bigInteger, scale);
        return sign == 0 ? bigDecimal.negate() : bigDecimal;
    }

    private static long decodeBigInt(ByteBuf in) {
        return in.readLongLE();
    }

    private static int decodeInt(ByteBuf in) {
        return in.readIntLE();
    }

    private static short decodeSmallInt(ByteBuf in) {
        return in.readShortLE();
    }

    private static short decodeTinyInt(ByteBuf in) {
        return in.readUnsignedByte();
    }

    private static long readUnsignedInt40LE(ByteBuf buffer) {
        long low = buffer.readUnsignedIntLE();
        short high = buffer.readUnsignedByte();
        return 0x100000000L * (long)high + low;
    }

    private static BigInteger readUnsignedInt96LE(ByteBuf buffer) {
        byte[] result = new byte[12];
        int readerIndex = buffer.readerIndex();
        for (int i = 0; i < 12; ++i) {
            result[i] = buffer.getByte(readerIndex + 11 - i);
        }
        buffer.skipBytes(12);
        return new BigInteger(result);
    }

    private static BigInteger readUnsignedInt128LE(ByteBuf buffer) {
        byte[] result = new byte[16];
        int readerIndex = buffer.readerIndex();
        for (int i = 0; i < 16; ++i) {
            result[i] = buffer.getByte(readerIndex + 15 - i);
        }
        buffer.skipBytes(16);
        return new BigInteger(result);
    }

    private static Object decodeIntN(ByteBuf buffer) {
        byte intNDataTypeLength = buffer.readByte();
        switch (intNDataTypeLength) {
            case 0: {
                return null;
            }
            case 1: {
                return buffer.readUnsignedByte();
            }
            case 2: {
                return buffer.readShortLE();
            }
            case 4: {
                return buffer.readIntLE();
            }
            case 8: {
                return buffer.readLongLE();
            }
        }
        throw new UnsupportedOperationException(String.format("SEVERE: Unsupported length=[%d] for decoding IntNDataType row value.", intNDataTypeLength));
    }

    private static Object decodeFltN(ByteBuf buffer) {
        byte fltNDataTypeLength = buffer.readByte();
        switch (fltNDataTypeLength) {
            case 0: {
                return null;
            }
            case 4: {
                return Float.valueOf(buffer.readFloatLE());
            }
            case 8: {
                return buffer.readDoubleLE();
            }
        }
        throw new UnsupportedOperationException(String.format("SEVERE: Unsupported length=[%d] for decoding FLTNTYPE row value.", fltNDataTypeLength));
    }

    private static Object decodeBitN(ByteBuf buffer) {
        byte bitNDataTypeLength = buffer.readByte();
        switch (bitNDataTypeLength) {
            case 0: {
                return null;
            }
            case 1: {
                return buffer.readBoolean();
            }
        }
        throw new UnsupportedOperationException(String.format("SEVERE: Unsupported length=[%d] for decoding BITNTYPE row value.", bitNDataTypeLength));
    }

    static {
        parameterDefinitionsMapping.put(Byte.class, "tinyint");
        parameterDefinitionsMapping.put(Short.class, "smallint");
        parameterDefinitionsMapping.put(Integer.class, "int");
        parameterDefinitionsMapping.put(Long.class, "bigint");
        parameterDefinitionsMapping.put(Boolean.class, "bit");
        parameterDefinitionsMapping.put(Float.class, "float");
        parameterDefinitionsMapping.put(Double.class, "float");
        parameterDefinitionsMapping.put(String.class, "nvarchar(4000)");
        parameterDefinitionsMapping.put(LocalDate.class, "date");
        parameterDefinitionsMapping.put(LocalTime.class, "time");
        parameterDefinitionsMapping.put(LocalDateTime.class, "datetime2(7)");
        parameterDefinitionsMapping.put(OffsetDateTime.class, "datetimeoffset(7)");
    }
}

