/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.vertx.core.Handler;
import io.vertx.mssqlclient.MSSQLException;
import io.vertx.mssqlclient.impl.codec.TdsMessageEncoder;
import io.vertx.mssqlclient.impl.protocol.MessageStatus;
import io.vertx.mssqlclient.impl.protocol.MessageType;
import io.vertx.mssqlclient.impl.protocol.TdsMessage;
import io.vertx.sqlclient.impl.command.CommandBase;
import io.vertx.sqlclient.impl.command.CommandResponse;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;

abstract class MSSQLCommandCodec<R, C extends CommandBase<R>> {
    final C cmd;
    public MSSQLException failure;
    public R result;
    Handler<? super CommandResponse<R>> completionHandler;
    TdsMessageEncoder encoder;

    MSSQLCommandCodec(C cmd) {
        this.cmd = cmd;
    }

    void encode(TdsMessageEncoder encoder) {
        this.encoder = encoder;
    }

    void encodeMessage(MessageType type, MessageStatus status, int processId, Consumer<ByteBuf> payloadEncoder) {
    }

    abstract void decodeMessage(TdsMessage var1, TdsMessageEncoder var2);

    void handleErrorToken(ByteBuf buffer) {
        int length = buffer.readUnsignedShortLE();
        int number = buffer.readIntLE();
        byte state = buffer.readByte();
        byte severity = buffer.readByte();
        String message = this.readUnsignedShortLenVarChar(buffer);
        String serverName = this.readByteLenVarchar(buffer);
        String procedureName = this.readByteLenVarchar(buffer);
        int lineNumber = buffer.readIntLE();
        MSSQLException failure = new MSSQLException(number, state, severity, message, serverName, procedureName, lineNumber);
        if (this.failure == null) {
            this.failure = failure;
        } else {
            this.failure.add(failure);
        }
    }

    void complete() {
        CommandResponse resp = this.failure != null ? CommandResponse.failure((Throwable)this.failure) : CommandResponse.success(this.result);
        this.completionHandler.handle((Object)resp);
    }

    protected String readByteLenVarchar(ByteBuf buffer) {
        short length = buffer.readUnsignedByte();
        return buffer.readCharSequence(length * 2, StandardCharsets.UTF_16LE).toString();
    }

    protected String readUnsignedShortLenVarChar(ByteBuf buffer) {
        int length = buffer.readUnsignedShortLE();
        return buffer.readCharSequence(length * 2, StandardCharsets.UTF_16LE).toString();
    }

    protected void writeUnsignedShortLenVarChar(ByteBuf buffer, String value) {
        buffer.writeShortLE(value.length() * 2);
        buffer.writeCharSequence((CharSequence)value, StandardCharsets.UTF_16LE);
    }
}

