/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.vertx.mssqlclient.impl.codec.MSSQLCommandCodec;
import io.vertx.mssqlclient.impl.codec.TdsMessageEncoder;
import io.vertx.mssqlclient.impl.protocol.MessageStatus;
import io.vertx.mssqlclient.impl.protocol.MessageType;
import io.vertx.mssqlclient.impl.protocol.TdsMessage;
import io.vertx.mssqlclient.impl.protocol.token.DataPacketStreamTokenType;
import io.vertx.mssqlclient.impl.utils.Utils;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.command.InitCommand;
import java.nio.charset.StandardCharsets;
import java.util.Map;

class InitCommandCodec
extends MSSQLCommandCodec<Connection, InitCommand> {
    InitCommandCodec(InitCommand cmd) {
        super(cmd);
    }

    @Override
    void encode(TdsMessageEncoder encoder) {
        super.encode(encoder);
        this.sendLoginMessage();
    }

    @Override
    void decodeMessage(TdsMessage message, TdsMessageEncoder encoder) {
        ByteBuf messageBody = message.content();
        while (messageBody.isReadable()) {
            DataPacketStreamTokenType tokenType = DataPacketStreamTokenType.valueOf(messageBody.readUnsignedByte());
            if (tokenType == null) continue;
            switch (tokenType) {
                case LOGINACK_TOKEN: {
                    this.result = ((InitCommand)this.cmd).connection();
                    break;
                }
                case ERROR_TOKEN: {
                    this.handleErrorToken(messageBody);
                    break;
                }
                case INFO_TOKEN: {
                    break;
                }
                case ENVCHANGE_TOKEN: {
                    break;
                }
            }
        }
        this.complete();
    }

    private void sendLoginMessage() {
        ChannelHandlerContext chctx = this.encoder.chctx;
        ByteBuf packet = chctx.alloc().ioBuffer();
        packet.writeByte(MessageType.TDS7_LOGIN.value());
        packet.writeByte(MessageStatus.NORMAL.value() | MessageStatus.END_OF_MESSAGE.value());
        int packetLenIdx = packet.writerIndex();
        packet.writeShort(0);
        packet.writeShort(0);
        packet.writeByte(0);
        packet.writeByte(0);
        int startIdx = packet.writerIndex();
        packet.writeInt(0);
        packet.writeInt(0x4000074);
        packet.writeIntLE(4096);
        packet.writeIntLE(0);
        packet.writeIntLE(0);
        packet.writeIntLE(0);
        packet.writeByte(16);
        packet.writeByte(0);
        packet.writeByte(0);
        packet.writeByte(0);
        packet.writeIntLE(0);
        packet.writeIntLE(0);
        Map properties = ((InitCommand)this.cmd).properties();
        String hostName = Utils.getHostName();
        int hostNameOffsetLengthIdx = packet.writerIndex();
        packet.writeShortLE(0);
        packet.writeShortLE(hostName.length());
        String userName = ((InitCommand)this.cmd).username();
        int userNameOffsetLengthIdx = packet.writerIndex();
        packet.writeShortLE(0);
        packet.writeShortLE(userName.length());
        String password = ((InitCommand)this.cmd).password();
        int passwordOffsetLengthIdx = packet.writerIndex();
        packet.writeShortLE(0);
        packet.writeShortLE(password.length());
        CharSequence appName = (CharSequence)properties.get("appName");
        if (appName == null || appName.length() == 0) {
            appName = "vertx-mssql-client";
        }
        int appNameOffsetLengthIdx = packet.writerIndex();
        packet.writeShortLE(0);
        packet.writeShortLE(appName.length());
        String serverName = ((InitCommand)this.cmd).connection().socket().remoteAddress().host();
        int serverNameOffsetLengthIdx = packet.writerIndex();
        packet.writeShortLE(0);
        packet.writeShortLE(serverName.length());
        int unusedOffsetLengthIdx = packet.writerIndex();
        packet.writeShortLE(0);
        packet.writeShortLE(0);
        CharSequence interfaceLibraryName = (CharSequence)properties.get("clientInterfaceName");
        if (interfaceLibraryName == null || interfaceLibraryName.length() == 0) {
            interfaceLibraryName = "Vert.x";
        }
        int cltIntNameOffsetLengthIdx = packet.writerIndex();
        packet.writeShortLE(0);
        packet.writeShortLE(interfaceLibraryName.length());
        int languageOffsetLengthIdx = packet.writerIndex();
        packet.writeShortLE(0);
        packet.writeShortLE(0);
        String database = ((InitCommand)this.cmd).database();
        int databaseOffsetLengthIdx = packet.writerIndex();
        packet.writeShortLE(0);
        packet.writeShortLE(database.length());
        packet.writeIntLE(0);
        packet.writeShortLE(0);
        int sspiOffsetLengthIdx = packet.writerIndex();
        packet.writeShortLE(0);
        packet.writeShortLE(0);
        int atchDbFileOffsetLengthIdx = packet.writerIndex();
        packet.writeShortLE(0);
        packet.writeShortLE(0);
        int changePasswordOffsetLengthIdx = packet.writerIndex();
        packet.writeShortLE(0);
        packet.writeShortLE(0);
        packet.writeIntLE(0);
        packet.setShortLE(hostNameOffsetLengthIdx, packet.writerIndex() - startIdx);
        packet.writeCharSequence((CharSequence)hostName, StandardCharsets.UTF_16LE);
        packet.setShortLE(userNameOffsetLengthIdx, packet.writerIndex() - startIdx);
        packet.writeCharSequence((CharSequence)userName, StandardCharsets.UTF_16LE);
        packet.setShortLE(passwordOffsetLengthIdx, packet.writerIndex() - startIdx);
        this.writePassword(packet, password);
        packet.setShortLE(appNameOffsetLengthIdx, packet.writerIndex() - startIdx);
        packet.writeCharSequence(appName, StandardCharsets.UTF_16LE);
        packet.setShortLE(serverNameOffsetLengthIdx, packet.writerIndex() - startIdx);
        packet.writeCharSequence((CharSequence)serverName, StandardCharsets.UTF_16LE);
        packet.setShortLE(unusedOffsetLengthIdx, packet.writerIndex() - startIdx);
        packet.setShortLE(cltIntNameOffsetLengthIdx, packet.writerIndex() - startIdx);
        packet.writeCharSequence(interfaceLibraryName, StandardCharsets.UTF_16LE);
        packet.setShortLE(languageOffsetLengthIdx, packet.writerIndex() - startIdx);
        packet.setShortLE(databaseOffsetLengthIdx, packet.writerIndex() - startIdx);
        packet.writeCharSequence((CharSequence)database, StandardCharsets.UTF_16LE);
        packet.setShortLE(sspiOffsetLengthIdx, packet.writerIndex() - startIdx);
        packet.setShortLE(atchDbFileOffsetLengthIdx, packet.writerIndex() - startIdx);
        packet.setShortLE(changePasswordOffsetLengthIdx, packet.writerIndex() - startIdx);
        packet.setIntLE(startIdx, packet.writerIndex() - startIdx);
        int packetLen = packet.writerIndex() - startIdx + 8;
        packet.setShort(packetLenIdx, packetLen);
        chctx.writeAndFlush((Object)packet, this.encoder.chctx.voidPromise());
    }

    private void writePassword(ByteBuf payload, String password) {
        byte[] bytes = password.getBytes(StandardCharsets.UTF_16LE);
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            bytes[i] = (byte)((b >> 4 | (b & 0xF) << 4) ^ 0xA5);
        }
        payload.writeBytes(bytes);
    }
}

