/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.vertx.core.buffer.Buffer;
import io.vertx.mssqlclient.impl.codec.MSSQLDataTypeCodec;
import io.vertx.mssqlclient.impl.codec.MSSQLPreparedStatement;
import io.vertx.mssqlclient.impl.codec.MSSQLRowDesc;
import io.vertx.mssqlclient.impl.codec.QueryCommandBaseCodec;
import io.vertx.mssqlclient.impl.codec.RowResultDecoder;
import io.vertx.mssqlclient.impl.codec.TdsMessageEncoder;
import io.vertx.mssqlclient.impl.protocol.MessageStatus;
import io.vertx.mssqlclient.impl.protocol.MessageType;
import io.vertx.mssqlclient.impl.protocol.TdsMessage;
import io.vertx.mssqlclient.impl.protocol.token.DataPacketStreamTokenType;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.impl.TupleInternal;
import io.vertx.sqlclient.impl.command.ExtendedQueryCommand;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;

class ExtendedQueryCommandCodec<T>
extends QueryCommandBaseCodec<T, ExtendedQueryCommand<T>> {
    private int rowCount;

    ExtendedQueryCommandCodec(ExtendedQueryCommand cmd) {
        super(cmd);
    }

    @Override
    void encode(TdsMessageEncoder encoder) {
        super.encode(encoder);
        MSSQLPreparedStatement ps = (MSSQLPreparedStatement)((ExtendedQueryCommand)this.cmd).preparedStatement();
        if (ps.handle > 0) {
            this.sendExecRequest();
        } else {
            this.sendPrepexecRequest();
        }
    }

    @Override
    void decodeMessage(TdsMessage message, TdsMessageEncoder encoder) {
        ByteBuf messageBody = message.content();
        block12: while (messageBody.isReadable()) {
            DataPacketStreamTokenType tokenType = DataPacketStreamTokenType.valueOf(messageBody.readUnsignedByte());
            if (tokenType == null) {
                throw new UnsupportedOperationException("Unsupported token: " + (Object)((Object)tokenType));
            }
            MSSQLPreparedStatement ps = (MSSQLPreparedStatement)((ExtendedQueryCommand)this.cmd).preparedStatement();
            switch (tokenType) {
                case COLMETADATA_TOKEN: {
                    MSSQLRowDesc rowDesc = this.decodeColmetadataToken(messageBody);
                    this.rowResultDecoder = new RowResultDecoder(((ExtendedQueryCommand)this.cmd).collector(), rowDesc);
                    continue block12;
                }
                case ROW_TOKEN: {
                    this.handleRow(messageBody);
                    continue block12;
                }
                case NBCROW_TOKEN: {
                    this.handleNbcRow(messageBody);
                    continue block12;
                }
                case DONE_TOKEN: {
                    messageBody.skipBytes(12);
                    continue block12;
                }
                case INFO_TOKEN: 
                case ORDER_TOKEN: {
                    int tokenLength = messageBody.readUnsignedShortLE();
                    messageBody.skipBytes(tokenLength);
                    continue block12;
                }
                case ERROR_TOKEN: {
                    this.handleErrorToken(messageBody);
                    continue block12;
                }
                case DONEPROC_TOKEN: {
                    messageBody.skipBytes(messageBody.readableBytes());
                    this.handleResultSetDone(this.rowCount);
                    continue block12;
                }
                case DONEINPROC_TOKEN: {
                    short status = messageBody.readShortLE();
                    short curCmd = messageBody.readShortLE();
                    long doneRowCount = messageBody.readLongLE();
                    if ((status | 0) != 0) {
                        this.rowCount = (int)((long)this.rowCount + doneRowCount);
                        continue block12;
                    }
                    this.handleResultSetDone((int)doneRowCount);
                    continue block12;
                }
                case RETURNSTATUS_TOKEN: {
                    messageBody.skipBytes(4);
                    continue block12;
                }
                case RETURNVALUE_TOKEN: {
                    if (ps.handle == 0) {
                        messageBody.skipBytes(2);
                        messageBody.skipBytes(2 * messageBody.readUnsignedByte());
                        messageBody.skipBytes(1);
                        messageBody.skipBytes(4);
                        messageBody.skipBytes(2);
                        messageBody.skipBytes(1);
                        messageBody.skipBytes(2);
                        ps.handle = messageBody.readIntLE();
                    }
                    messageBody.skipBytes(messageBody.readableBytes());
                    this.handleResultSetDone(this.rowCount);
                    continue block12;
                }
            }
            throw new UnsupportedOperationException("Unsupported token: " + (Object)((Object)tokenType));
        }
        this.complete();
    }

    private void sendPrepexecRequest() {
        ChannelHandlerContext chctx = this.encoder.chctx;
        ByteBuf packet = chctx.alloc().ioBuffer();
        packet.writeByte(MessageType.RPC.value());
        packet.writeByte(MessageStatus.NORMAL.value() | MessageStatus.END_OF_MESSAGE.value());
        int packetLenIdx = packet.writerIndex();
        packet.writeShort(0);
        packet.writeShort(0);
        packet.writeByte(0);
        packet.writeByte(0);
        int start = packet.writerIndex();
        packet.writeIntLE(0);
        this.encodeTransactionDescriptor(packet);
        packet.setIntLE(start, packet.writerIndex() - start);
        packet.writeShortLE(65535);
        packet.writeShortLE(13);
        packet.writeShortLE(0);
        packet.writeByte(0);
        packet.writeByte(1);
        packet.writeByte(38);
        packet.writeByte(4);
        packet.writeByte(4);
        MSSQLPreparedStatement ps = (MSSQLPreparedStatement)((ExtendedQueryCommand)this.cmd).ps;
        packet.writeIntLE(ps.handle);
        Tuple params = ((ExtendedQueryCommand)this.cmd).params();
        String paramDefinitions = this.parseParamDefinitions((TupleInternal)params);
        this.encodeNVarcharParameter(packet, paramDefinitions);
        this.encodeNVarcharParameter(packet, ((ExtendedQueryCommand)this.cmd).sql());
        for (int i = 0; i < params.size(); ++i) {
            this.encodeParamValue(packet, params.getValue(i));
        }
        int packetLen = packet.writerIndex() - packetLenIdx + 2;
        packet.setShort(packetLenIdx, packetLen);
        chctx.writeAndFlush((Object)packet);
    }

    private void sendExecRequest() {
        ChannelHandlerContext chctx = this.encoder.chctx;
        ByteBuf packet = chctx.alloc().ioBuffer();
        packet.writeByte(MessageType.RPC.value());
        packet.writeByte(MessageStatus.NORMAL.value() | MessageStatus.END_OF_MESSAGE.value());
        int packetLenIdx = packet.writerIndex();
        packet.writeShort(0);
        packet.writeShort(0);
        packet.writeByte(0);
        packet.writeByte(0);
        int start = packet.writerIndex();
        packet.writeIntLE(0);
        this.encodeTransactionDescriptor(packet);
        packet.setIntLE(start, packet.writerIndex() - start);
        packet.writeShortLE(65535);
        packet.writeShortLE(12);
        packet.writeShortLE(0);
        packet.writeByte(0);
        packet.writeByte(0);
        packet.writeByte(38);
        packet.writeByte(4);
        packet.writeByte(4);
        MSSQLPreparedStatement ps = (MSSQLPreparedStatement)((ExtendedQueryCommand)this.cmd).ps;
        packet.writeIntLE(ps.handle);
        Tuple params = ((ExtendedQueryCommand)this.cmd).params();
        for (int i = 0; i < params.size(); ++i) {
            this.encodeParamValue(packet, params.getValue(i));
        }
        int packetLen = packet.writerIndex() - packetLenIdx + 2;
        packet.setShort(packetLenIdx, packetLen);
        chctx.writeAndFlush((Object)packet, this.encoder.chctx.voidPromise());
    }

    private String parseParamDefinitions(TupleInternal params) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < params.size(); ++i) {
            Object param = params.getValueInternal(i);
            stringBuilder.append("@P").append(i + 1).append(" ");
            stringBuilder.append(MSSQLDataTypeCodec.inferenceParamDefinitionByValueType(param));
            if (i == params.size() - 1) continue;
            stringBuilder.append(",");
        }
        return stringBuilder.toString();
    }

    private void encodeNVarcharParameter(ByteBuf payload, String value) {
        payload.writeByte(0);
        payload.writeByte(0);
        payload.writeByte(231);
        payload.writeShortLE(8000);
        payload.writeByte(9);
        payload.writeByte(4);
        payload.writeByte(208);
        payload.writeByte(0);
        payload.writeByte(52);
        this.writeUnsignedShortLenVarChar(payload, value);
    }

    private void encodeParamValue(ByteBuf payload, Object value) {
        if (value == null) {
            this.encodeNullParameter(payload);
        } else if (value instanceof Byte) {
            this.encodeIntNParameter(payload, 1, value);
        } else if (value instanceof Short) {
            this.encodeIntNParameter(payload, 2, value);
        } else if (value instanceof Integer) {
            this.encodeIntNParameter(payload, 4, value);
        } else if (value instanceof Long) {
            this.encodeIntNParameter(payload, 8, value);
        } else if (value instanceof Float) {
            this.encodeFloat4Parameter(payload, (Float)value);
        } else if (value instanceof Double) {
            this.encodeFloat8Parameter(payload, (Double)value);
        } else if (value instanceof String) {
            this.encodeNVarcharParameter(payload, (String)value);
        } else if (value instanceof Enum) {
            this.encodeNVarcharParameter(payload, ((Enum)value).name());
        } else if (value instanceof Boolean) {
            this.encodeBitNParameter(payload, (Boolean)value);
        } else if (value instanceof LocalDate) {
            this.encodeDateNParameter(payload, (LocalDate)value);
        } else if (value instanceof LocalTime) {
            this.encodeTimeNParameter(payload, (LocalTime)value, (byte)6);
        } else if (value instanceof LocalDateTime) {
            this.encodeDateTimeNParameter(payload, (LocalDateTime)value, (byte)6);
        } else if (value instanceof OffsetDateTime) {
            this.encodeOffsetDateTimeNParameter(payload, (OffsetDateTime)value, (byte)6);
        } else if (value instanceof BigDecimal) {
            this.encodeDecimalParameter(payload, (BigDecimal)value);
        } else if (value instanceof Buffer) {
            this.encodeBufferParameter(payload, (Buffer)value);
        } else {
            throw new UnsupportedOperationException("Unsupported type");
        }
    }

    private void encodeNullParameter(ByteBuf payload) {
        payload.writeByte(0);
        payload.writeByte(0);
        payload.writeByte(31);
    }

    private void encodeIntNParameter(ByteBuf payload, int n, Object value) {
        payload.writeByte(0);
        payload.writeByte(0);
        payload.writeByte(38);
        payload.writeByte(n);
        payload.writeByte(n);
        switch (n) {
            case 1: {
                payload.writeByte((int)((Byte)value).byteValue());
                break;
            }
            case 2: {
                payload.writeShortLE((int)((Short)value).shortValue());
                break;
            }
            case 4: {
                payload.writeIntLE(((Integer)value).intValue());
                break;
            }
            case 8: {
                payload.writeLongLE(((Long)value).longValue());
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    private void encodeBitNParameter(ByteBuf payload, Boolean bit) {
        payload.writeByte(0);
        payload.writeByte(0);
        payload.writeByte(104);
        payload.writeByte(1);
        payload.writeByte(1);
        payload.writeBoolean(bit.booleanValue());
    }

    private void encodeFloat4Parameter(ByteBuf payload, Float value) {
        payload.writeByte(0);
        payload.writeByte(0);
        payload.writeByte(109);
        payload.writeByte(4);
        payload.writeByte(4);
        payload.writeFloatLE(value.floatValue());
    }

    private void encodeFloat8Parameter(ByteBuf payload, Double value) {
        payload.writeByte(0);
        payload.writeByte(0);
        payload.writeByte(109);
        payload.writeByte(8);
        payload.writeByte(8);
        payload.writeDoubleLE(value.doubleValue());
    }

    private void encodeDateNParameter(ByteBuf payload, LocalDate date) {
        payload.writeByte(0);
        payload.writeByte(0);
        payload.writeByte(40);
        if (date == null) {
            payload.writeByte(0);
        } else {
            payload.writeByte(3);
            long days = ChronoUnit.DAYS.between(MSSQLDataTypeCodec.START_DATE, date);
            payload.writeMediumLE((int)days);
        }
    }

    private void encodeTimeNParameter(ByteBuf payload, LocalTime time, byte scale) {
        payload.writeByte(0);
        payload.writeByte(0);
        payload.writeByte(41);
        payload.writeByte((int)scale);
        if (time == null) {
            payload.writeByte(0);
        } else {
            int length = scale <= 2 ? 3 : (scale <= 4 ? 4 : 5);
            payload.writeByte(length);
            long nanos = time.getNano();
            int seconds = time.toSecondOfDay();
            long value = (long)((double)seconds * Math.pow(10.0, scale) + (double)nanos);
            this.encodeInt40(payload, value);
        }
    }

    private void encodeDateTimeNParameter(ByteBuf payload, LocalDateTime dateTime, byte scale) {
        payload.writeByte(0);
        payload.writeByte(0);
        payload.writeByte(42);
        payload.writeByte((int)scale);
        if (dateTime == null) {
            payload.writeByte(0);
        } else {
            int length = scale <= 2 ? 3 : (scale <= 4 ? 4 : 5);
            payload.writeByte(length += 3);
            LocalTime localTime = dateTime.toLocalTime();
            long nanos = localTime.getNano();
            int seconds = localTime.toSecondOfDay();
            long value = (long)((double)seconds * Math.pow(10.0, scale) + (double)nanos);
            this.encodeInt40(payload, value);
            long days = ChronoUnit.DAYS.between(MSSQLDataTypeCodec.START_DATE, dateTime.toLocalDate());
            payload.writeMediumLE((int)days);
        }
    }

    private void encodeOffsetDateTimeNParameter(ByteBuf payload, OffsetDateTime offsetDateTime, byte scale) {
        payload.writeByte(0);
        payload.writeByte(0);
        payload.writeByte(43);
        payload.writeByte((int)scale);
        if (offsetDateTime == null) {
            payload.writeByte(0);
        } else {
            int length = scale <= 2 ? 3 : (scale <= 4 ? 4 : 5);
            payload.writeByte(length += 5);
            int minutes = offsetDateTime.getOffset().getTotalSeconds() / 60;
            LocalDateTime localDateTime = offsetDateTime.toLocalDateTime().minusMinutes(minutes);
            LocalTime localTime = localDateTime.toLocalTime();
            long nanos = localTime.getNano();
            int seconds = localTime.toSecondOfDay();
            long value = (long)((double)seconds * Math.pow(10.0, scale) + (double)nanos);
            this.encodeInt40(payload, value);
            long days = ChronoUnit.DAYS.between(MSSQLDataTypeCodec.START_DATE, localDateTime.toLocalDate());
            payload.writeMediumLE((int)days);
            payload.writeShortLE(minutes);
        }
    }

    private void encodeInt40(ByteBuf buffer, long value) {
        buffer.writeIntLE((int)(value % 0x100000000L));
        buffer.writeByte((int)(value / 0x100000000L));
    }

    private void encodeDecimalParameter(ByteBuf payload, BigDecimal value) {
        payload.writeByte(0);
        payload.writeByte(0);
        payload.writeByte(106);
        payload.writeByte(17);
        payload.writeByte(38);
        int sign = value.signum() < 0 ? 0 : 1;
        byte[] bytes = (sign == 0 ? value.negate() : value).unscaledValue().toByteArray();
        payload.writeByte(Math.max(0, value.scale()));
        payload.writeByte(1 + bytes.length);
        payload.writeByte(sign);
        for (int i = bytes.length - 1; i >= 0; --i) {
            payload.writeByte((int)bytes[i]);
        }
    }

    private void encodeBufferParameter(ByteBuf payload, Buffer value) {
        payload.writeByte(0);
        payload.writeByte(0);
        payload.writeByte(173);
        payload.writeShortLE(value.length());
        payload.writeShortLE(value.length());
        payload.writeBytes(value.getByteBuf());
    }
}

