/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.vertx.mssqlclient.impl.codec.MSSQLCommandCodec;
import io.vertx.mssqlclient.impl.codec.MSSQLPreparedStatement;
import io.vertx.mssqlclient.impl.codec.TdsMessageEncoder;
import io.vertx.mssqlclient.impl.protocol.MessageStatus;
import io.vertx.mssqlclient.impl.protocol.MessageType;
import io.vertx.mssqlclient.impl.protocol.TdsMessage;
import io.vertx.mssqlclient.impl.protocol.token.DataPacketStreamTokenType;
import io.vertx.sqlclient.impl.command.CloseStatementCommand;
import io.vertx.sqlclient.impl.command.CommandResponse;

class CloseStatementCommandCodec
extends MSSQLCommandCodec<Void, CloseStatementCommand> {
    CloseStatementCommandCodec(CloseStatementCommand cmd) {
        super(cmd);
    }

    @Override
    void encode(TdsMessageEncoder encoder) {
        super.encode(encoder);
        MSSQLPreparedStatement ps = (MSSQLPreparedStatement)((CloseStatementCommand)this.cmd).statement();
        if (ps.handle > 0) {
            this.sendUnprepareRequest();
        } else {
            this.completionHandler.handle((Object)CommandResponse.success(null));
        }
    }

    @Override
    void decodeMessage(TdsMessage message, TdsMessageEncoder encoder) {
        ByteBuf messageBody = message.content();
        block5: while (messageBody.isReadable()) {
            DataPacketStreamTokenType tokenType = DataPacketStreamTokenType.valueOf(messageBody.readUnsignedByte());
            if (tokenType == null) {
                throw new UnsupportedOperationException("Unsupported token: " + (Object)((Object)tokenType));
            }
            switch (tokenType) {
                case ERROR_TOKEN: {
                    this.handleErrorToken(messageBody);
                    continue block5;
                }
                case DONEPROC_TOKEN: {
                    messageBody.skipBytes(12);
                    continue block5;
                }
                case RETURNSTATUS_TOKEN: {
                    messageBody.skipBytes(4);
                    continue block5;
                }
            }
            throw new UnsupportedOperationException("Unsupported token: " + (Object)((Object)tokenType));
        }
        this.complete();
    }

    private void sendUnprepareRequest() {
        ChannelHandlerContext chctx = this.encoder.chctx;
        ByteBuf packet = chctx.alloc().ioBuffer();
        packet.writeByte(MessageType.RPC.value());
        packet.writeByte(MessageStatus.NORMAL.value() | MessageStatus.END_OF_MESSAGE.value());
        int packetLenIdx = packet.writerIndex();
        packet.writeShort(0);
        packet.writeShort(0);
        packet.writeByte(0);
        packet.writeByte(0);
        int start = packet.writerIndex();
        packet.writeIntLE(0);
        this.encodeTransactionDescriptor(packet, 0L, 1);
        packet.setIntLE(start, packet.writerIndex() - start);
        packet.writeShortLE(65535);
        packet.writeShortLE(15);
        packet.writeShortLE(0);
        this.encodeIntNParameter(packet, ((MSSQLPreparedStatement)((CloseStatementCommand)this.cmd).statement()).handle);
        int packetLen = packet.writerIndex() - packetLenIdx + 2;
        packet.setShort(packetLenIdx, packetLen);
        chctx.writeAndFlush((Object)packet);
    }

    protected void encodeTransactionDescriptor(ByteBuf payload, long transactionDescriptor, int outstandingRequestCount) {
        payload.writeIntLE(18);
        payload.writeShortLE(2);
        payload.writeLongLE(transactionDescriptor);
        payload.writeIntLE(outstandingRequestCount);
    }

    private void encodeIntNParameter(ByteBuf payload, Object value) {
        payload.writeByte(0);
        payload.writeByte(0);
        payload.writeByte(38);
        payload.writeByte(4);
        payload.writeByte(4);
        payload.writeIntLE(((Integer)value).intValue());
    }
}

