/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.impl;

import io.vertx.core.Closeable;
import io.vertx.core.impl.CloseFuture;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.mssqlclient.MSSQLConnectOptions;
import io.vertx.mssqlclient.MSSQLPool;
import io.vertx.mssqlclient.impl.MSSQLConnectionFactory;
import io.vertx.mssqlclient.impl.MSSQLConnectionImpl;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.ConnectionFactory;
import io.vertx.sqlclient.impl.PoolBase;
import io.vertx.sqlclient.impl.SqlConnectionImpl;
import io.vertx.sqlclient.impl.tracing.QueryTracer;

public class MSSQLPoolImpl
extends PoolBase<MSSQLPoolImpl>
implements MSSQLPool {
    private final MSSQLConnectionFactory connectionFactory;

    public static MSSQLPoolImpl create(VertxInternal vertx, boolean closeVertx, MSSQLConnectOptions connectOptions, PoolOptions poolOptions) {
        QueryTracer tracer = vertx.tracer() == null ? null : new QueryTracer(vertx.tracer(), (SqlConnectOptions)connectOptions);
        VertxMetrics vertxMetrics = vertx.metricsSPI();
        ClientMetrics metrics = vertxMetrics != null ? vertxMetrics.createClientMetrics(connectOptions.getSocketAddress(), "sql", connectOptions.getMetricsName()) : null;
        MSSQLPoolImpl pool = new MSSQLPoolImpl(vertx, new MSSQLConnectionFactory(vertx, connectOptions), tracer, metrics, poolOptions);
        pool.init();
        CloseFuture closeFuture = pool.closeFuture();
        if (closeVertx) {
            closeFuture.future().onComplete(ar -> vertx.close());
        } else {
            ContextInternal ctx = vertx.getContext();
            if (ctx != null) {
                ctx.addCloseHook((Closeable)closeFuture);
            } else {
                vertx.addCloseHook((Closeable)closeFuture);
            }
        }
        return pool;
    }

    private MSSQLPoolImpl(VertxInternal vertx, MSSQLConnectionFactory factory, QueryTracer tracer, ClientMetrics metrics, PoolOptions poolOptions) {
        super(vertx, (ConnectionFactory)factory, tracer, metrics, 1, poolOptions);
        this.connectionFactory = factory;
    }

    public int appendQueryPlaceholder(StringBuilder queryBuilder, int index, int current) {
        queryBuilder.append('@').append('P').append(1 + index);
        return index;
    }

    protected SqlConnectionImpl wrap(ContextInternal context, Connection connection) {
        return new MSSQLConnectionImpl(this.connectionFactory, context, connection, this.tracer, this.metrics);
    }
}

