/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.impl;

import io.vertx.core.Closeable;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.mssqlclient.MSSQLConnectOptions;
import io.vertx.mssqlclient.MSSQLConnection;
import io.vertx.mssqlclient.impl.MSSQLConnectionFactory;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.SqlConnectionImpl;
import io.vertx.sqlclient.impl.tracing.QueryTracer;

public class MSSQLConnectionImpl
extends SqlConnectionImpl<MSSQLConnectionImpl>
implements MSSQLConnection {
    private final MSSQLConnectionFactory factory;

    public MSSQLConnectionImpl(MSSQLConnectionFactory factory, ContextInternal context, Connection conn, QueryTracer tracer, ClientMetrics metrics) {
        super(context, conn, tracer, metrics);
        this.factory = factory;
    }

    public int appendQueryPlaceholder(StringBuilder queryBuilder, int index, int current) {
        queryBuilder.append('@').append('P').append(1 + index);
        return index;
    }

    public static Future<MSSQLConnection> connect(Vertx vertx, MSSQLConnectOptions options) {
        ContextInternal ctx = (ContextInternal)vertx.getOrCreateContext();
        QueryTracer tracer = ctx.tracer() == null ? null : new QueryTracer(ctx.tracer(), (SqlConnectOptions)options);
        MSSQLConnectionFactory client = new MSSQLConnectionFactory(ctx.owner(), options);
        ctx.addCloseHook((Closeable)client);
        PromiseInternal promise = ctx.promise();
        ctx.emit(null, arg_0 -> MSSQLConnectionImpl.lambda$connect$0(client, (Promise)promise, arg_0));
        return promise.future().map(conn -> {
            MSSQLConnectionImpl msConn = new MSSQLConnectionImpl(client, ctx, (Connection)conn, tracer, null);
            conn.init((Connection.Holder)msConn);
            return msConn;
        });
    }

    private static /* synthetic */ void lambda$connect$0(MSSQLConnectionFactory client, Promise promise, Object v) {
        client.connect(promise);
    }
}

