/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.EventLoopContext;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.impl.NetSocketInternal;
import io.vertx.mssqlclient.MSSQLConnectOptions;
import io.vertx.mssqlclient.impl.MSSQLSocketConnection;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.ConnectionFactory;
import io.vertx.sqlclient.impl.SqlConnectionFactoryBase;

class MSSQLConnectionFactory
extends SqlConnectionFactoryBase
implements ConnectionFactory {
    MSSQLConnectionFactory(VertxInternal vertx, MSSQLConnectOptions options) {
        super(vertx, (SqlConnectOptions)options);
    }

    protected void initializeConfiguration(SqlConnectOptions options) {
    }

    protected void configureNetClientOptions(NetClientOptions netClientOptions) {
    }

    protected void doConnectInternal(Promise<Connection> promise) {
        PromiseInternal promiseInternal = (PromiseInternal)promise;
        EventLoopContext context = ConnectionFactory.asEventLoopContext((ContextInternal)promiseInternal.context());
        Future fut = this.netClient.connect(this.socketAddress);
        fut.onComplete(ar -> {
            if (ar.succeeded()) {
                NetSocket so = (NetSocket)ar.result();
                MSSQLSocketConnection conn = new MSSQLSocketConnection((NetSocketInternal)so, false, 0, sql -> true, 1, context);
                conn.init();
                conn.sendPreLoginMessage(false, (Handler<AsyncResult<Void>>)((Handler)preLogin -> {
                    if (preLogin.succeeded()) {
                        conn.sendLoginMessage(this.username, this.password, this.database, this.properties, (Handler<AsyncResult<Connection>>)promise);
                    } else {
                        promise.fail(preLogin.cause());
                    }
                }));
            } else {
                promise.fail(ar.cause());
            }
        });
    }
}

