/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.data;

import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.mssqlclient.data.MSSQLNullableDataTypeTestBase;
import io.vertx.sqlclient.ColumnChecker;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.data.Numeric;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.function.Consumer;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class MSSQLPreparedQueryNullableDataTypeTest
extends MSSQLNullableDataTypeTestBase {
    @Test
    public void testEncodeTinyInt(TestContext ctx) {
        this.testEncodeNumber(ctx, "test_tinyint", (short)255);
    }

    @Test
    public void testEncodeNullTinyInt(TestContext ctx) {
        this.testPreparedQueryEncodeGeneric(ctx, "nullable_datatype", "test_tinyint", SHORT_NULL_VALUE, row -> ColumnChecker.checkColumn((int)0, (String)"test_tinyint").returnsNull().forRow(row));
    }

    @Test
    public void testEncodeSmallInt(TestContext ctx) {
        this.testEncodeNumber(ctx, "test_smallint", (short)Short.MIN_VALUE);
    }

    @Test
    public void testEncodeNullSmallInt(TestContext ctx) {
        this.testPreparedQueryEncodeGeneric(ctx, "nullable_datatype", "test_smallint", SHORT_NULL_VALUE, row -> ColumnChecker.checkColumn((int)0, (String)"test_smallint").returnsNull().forRow(row));
    }

    @Test
    public void testEncodeInt(TestContext ctx) {
        this.testEncodeNumber(ctx, "test_int", Integer.MIN_VALUE);
    }

    @Test
    public void testEncodeNullInt(TestContext ctx) {
        this.testPreparedQueryEncodeGeneric(ctx, "nullable_datatype", "test_int", INT_NULL_VALUE, row -> ColumnChecker.checkColumn((int)0, (String)"test_int").returnsNull().forRow(row));
    }

    @Test
    public void testEncodeBigInt(TestContext ctx) {
        this.testEncodeNumber(ctx, "test_bigint", Long.MIN_VALUE);
    }

    @Test
    public void testEncodeNullBigInt(TestContext ctx) {
        this.testPreparedQueryEncodeGeneric(ctx, "nullable_datatype", "test_bigint", LONG_NULL_VALUE, row -> ColumnChecker.checkColumn((int)0, (String)"test_bigint").returnsNull().forRow(row));
    }

    @Test
    public void testEncodeFloat4(TestContext ctx) {
        this.testEncodeNumber(ctx, "test_float_4", Float.valueOf(-3.40282E38f));
    }

    @Test
    public void testEncodeNullFloat4(TestContext ctx) {
        this.testPreparedQueryEncodeGeneric(ctx, "nullable_datatype", "test_float_4", FLOAT_NULL_VALUE, row -> ColumnChecker.checkColumn((int)0, (String)"test_float_4").returnsNull().forRow(row));
    }

    @Test
    public void testEncodeFloat8(TestContext ctx) {
        this.testEncodeNumber(ctx, "test_float_8", -1.7976931348623157E308);
    }

    @Test
    public void testEncodeNullFloat8(TestContext ctx) {
        this.testPreparedQueryEncodeGeneric(ctx, "nullable_datatype", "test_float_8", DOUBLE_NULL_VALUE, row -> ColumnChecker.checkColumn((int)0, (String)"test_float_8").returnsNull().forRow(row));
    }

    @Test
    @Ignore
    public void testEncodeNumeric(TestContext ctx) {
        this.testEncodeNumber(ctx, "test_numeric", (Number)Numeric.create((Number)1.2345678913E8));
    }

    @Test
    public void testEncodeNullNumeric(TestContext ctx) {
        this.testPreparedQueryEncodeGeneric(ctx, "nullable_datatype", "test_numeric", NUMERIC_NULL_VALUE, row -> ColumnChecker.checkColumn((int)0, (String)"test_numeric").returnsNull().forRow(row));
    }

    @Test
    @Ignore
    public void testEncodeDecimal(TestContext ctx) {
        this.testEncodeNumber(ctx, "test_decimal", (Number)Numeric.create((Number)123456789));
    }

    @Test
    public void testEncodeNullDecimal(TestContext ctx) {
        this.testPreparedQueryEncodeGeneric(ctx, "nullable_datatype", "test_decimal", NUMERIC_NULL_VALUE, row -> ColumnChecker.checkColumn((int)0, (String)"test_decimal").returnsNull().forRow(row));
    }

    @Test
    public void testEncodeBit(TestContext ctx) {
        this.testEncodeBitValue(ctx, false);
    }

    @Test
    public void testEncodeNullBit(TestContext ctx) {
        this.testEncodeBitValue(ctx, BOOLEAN_NULL_VALUE);
    }

    private void testEncodeBitValue(TestContext ctx, Boolean value) {
        this.testPreparedQueryEncodeGeneric(ctx, "nullable_datatype", "test_boolean", value, row -> {
            ColumnChecker checker = ColumnChecker.checkColumn((int)0, (String)"test_boolean");
            if (value == null) {
                checker.returnsNull();
            } else {
                checker.returns(Tuple::getValue, Row::getValue, (Object)value).returns(Tuple::getBoolean, Row::getBoolean, (Object)value).returns(Boolean.class, (Object)value);
            }
            checker.forRow(row);
        });
    }

    @Test
    public void testEncodeChar(TestContext ctx) {
        this.testEncodeCharValue(ctx, "chartest");
    }

    @Test
    public void testEncodeNullChar(TestContext ctx) {
        this.testEncodeCharValue(ctx, STRING_NULL_VALUE);
    }

    private void testEncodeCharValue(TestContext ctx, String value) {
        this.testPreparedQueryEncodeGeneric(ctx, "nullable_datatype", "test_char", value, row -> {
            ColumnChecker checker = ColumnChecker.checkColumn((int)0, (String)"test_char");
            if (value == null) {
                checker.returnsNull();
            } else {
                checker.returns(Tuple::getValue, Row::getValue, (Object)value).returns(Tuple::getString, Row::getString, (Object)value).returns(String.class, (Object)value);
            }
            checker.forRow(row);
        });
    }

    @Test
    public void testEncodeVarChar(TestContext ctx) {
        this.testEncodeVarCharValue(ctx, "testedvarchar");
    }

    @Test
    public void testEncodeNullVarChar(TestContext ctx) {
        this.testEncodeVarCharValue(ctx, STRING_NULL_VALUE);
    }

    private void testEncodeVarCharValue(TestContext ctx, String value) {
        this.testPreparedQueryEncodeGeneric(ctx, "nullable_datatype", "test_varchar", value, row -> {
            ColumnChecker checker = ColumnChecker.checkColumn((int)0, (String)"test_varchar");
            if (value == null) {
                checker.returnsNull();
            } else {
                checker.returns(Tuple::getValue, Row::getValue, (Object)value).returns(Tuple::getString, Row::getString, (Object)value).returns(String.class, (Object)value);
            }
            checker.forRow(row);
        });
    }

    @Test
    public void testEncodeDate(TestContext ctx) {
        this.testEncodeDateValue(ctx, LocalDate.of(1999, 12, 31));
    }

    @Test
    public void testEncodeNullDate(TestContext ctx) {
        this.testEncodeDateValue(ctx, LOCALDATE_NULL_VALUE);
    }

    private void testEncodeDateValue(TestContext ctx, LocalDate value) {
        this.testPreparedQueryEncodeGeneric(ctx, "nullable_datatype", "test_date", value, row -> {
            ColumnChecker checker = ColumnChecker.checkColumn((int)0, (String)"test_date");
            if (value == null) {
                checker.returnsNull();
            } else {
                checker.returns(Tuple::getValue, Row::getValue, (Object)value).returns(Tuple::getLocalDate, Row::getLocalDate, (Object)value).returns(LocalDate.class, (Object)value);
            }
            checker.forRow(row);
        });
    }

    @Test
    public void testEncodeTime(TestContext ctx) {
        this.testEncodeTimeValue(ctx, LocalTime.of(23, 10, 45));
    }

    @Test
    public void testEncodeNullTime(TestContext ctx) {
        this.testEncodeTimeValue(ctx, LOCALTIME_NULL_VALUE);
    }

    private void testEncodeTimeValue(TestContext ctx, LocalTime value) {
        this.testPreparedQueryEncodeGeneric(ctx, "nullable_datatype", "test_time", value, row -> {
            ColumnChecker checker = ColumnChecker.checkColumn((int)0, (String)"test_time");
            if (value == null) {
                checker.returnsNull();
            } else {
                checker.returns(Tuple::getValue, Row::getValue, (Object)value).returns(Tuple::getLocalTime, Row::getLocalTime, (Object)value).returns(LocalTime.class, (Object)value);
            }
            checker.forRow(row);
        });
    }

    @Test
    public void testEncodeDateTime(TestContext ctx) {
        this.testEncodeDateTimeValue(ctx, LocalDateTime.of(1999, 12, 31, 23, 10, 45));
    }

    @Test
    public void testEncodeNullDateTime(TestContext ctx) {
        this.testEncodeDateTimeValue(ctx, LOCALDATETIME_NULL_VALUE);
    }

    private void testEncodeDateTimeValue(TestContext ctx, LocalDateTime value) {
        this.testPreparedQueryEncodeGeneric(ctx, "nullable_datatype", "test_datetime2", value, row -> {
            ColumnChecker checker = ColumnChecker.checkColumn((int)0, (String)"test_datetime2");
            if (value == null) {
                checker.returnsNull();
            } else {
                checker.returns(Tuple::getValue, Row::getValue, (Object)value).returns(Tuple::getLocalDateTime, Row::getLocalDateTime, (Object)value).returns(Tuple::getLocalDate, Row::getLocalDate, (Object)value.toLocalDate()).returns(Tuple::getLocalTime, Row::getLocalTime, (Object)value.toLocalTime()).returns(LocalDateTime.class, (Object)value).forRow(row);
            }
        });
    }

    private void testEncodeNumber(TestContext ctx, String columnName, Number value) {
        this.testPreparedQueryEncodeGeneric(ctx, "nullable_datatype", columnName, value, row -> MSSQLPreparedQueryNullableDataTypeTest.checkNumber(row, columnName, value));
    }

    @Override
    protected void testDecodeValue(TestContext ctx, boolean isNull, String columnName, Consumer<Row> checker) {
        if (isNull) {
            this.testPreparedQueryDecodeGeneric(ctx, "nullable_datatype", columnName, "3", checker);
        } else {
            this.testPreparedQueryDecodeGeneric(ctx, "nullable_datatype", columnName, "1", checker);
        }
    }
}

