/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.data;

import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.mssqlclient.data.MSSQLNotNullableDataTypeTestBase;
import io.vertx.sqlclient.ColumnChecker;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.data.Numeric;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.function.Consumer;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class MSSQLPreparedQueryNotNullableDataTypeTest
extends MSSQLNotNullableDataTypeTestBase {
    @Test
    public void testEncodeTinyInt(TestContext ctx) {
        this.testEncodeNumber(ctx, "test_tinyint", (short)255);
    }

    @Test
    public void testEncodeSmallInt(TestContext ctx) {
        this.testEncodeNumber(ctx, "test_smallint", (short)Short.MIN_VALUE);
    }

    @Test
    public void testEncodeInt(TestContext ctx) {
        this.testEncodeNumber(ctx, "test_int", Integer.MIN_VALUE);
    }

    @Test
    public void testEncodeBigInt(TestContext ctx) {
        this.testEncodeNumber(ctx, "test_bigint", Long.MIN_VALUE);
    }

    @Test
    public void testEncodeFloat4(TestContext ctx) {
        this.testEncodeNumber(ctx, "test_float_4", Float.valueOf(-3.40282E38f));
    }

    @Test
    public void testEncodeFloat8(TestContext ctx) {
        this.testEncodeNumber(ctx, "test_float_8", -1.7976931348623157E308);
    }

    @Test
    @Ignore
    public void testEncodeNumeric(TestContext ctx) {
        this.testEncodeNumber(ctx, "test_numeric", (Number)Numeric.create((Number)new BigDecimal("123456789.127")));
    }

    @Test
    @Ignore
    public void testEncodeDecimal(TestContext ctx) {
        this.testEncodeNumber(ctx, "test_decimal", (Number)Numeric.create((Number)new BigDecimal("123456789")));
    }

    @Test
    public void testEncodeBit(TestContext ctx) {
        this.testPreparedQueryEncodeGeneric(ctx, "not_nullable_datatype", "test_boolean", false, row -> ColumnChecker.checkColumn((int)0, (String)"test_boolean").returns(Tuple::getValue, Row::getValue, (Object)false).returns(Tuple::getBoolean, Row::getBoolean, (Object)false).returns(Boolean.class, (Object)false).forRow(row));
    }

    @Test
    public void testEncodeChar(TestContext ctx) {
        this.testPreparedQueryEncodeGeneric(ctx, "not_nullable_datatype", "test_char", "chartest", row -> ColumnChecker.checkColumn((int)0, (String)"test_char").returns(Tuple::getValue, Row::getValue, (Object)"chartest").returns(Tuple::getString, Row::getString, (Object)"chartest").returns(String.class, (Object)"chartest").forRow(row));
    }

    @Test
    public void testEncodeVarChar(TestContext ctx) {
        this.testPreparedQueryEncodeGeneric(ctx, "not_nullable_datatype", "test_varchar", "testedvarchar", row -> ColumnChecker.checkColumn((int)0, (String)"test_varchar").returns(Tuple::getValue, Row::getValue, (Object)"testedvarchar").returns(Tuple::getString, Row::getString, (Object)"testedvarchar").returns(String.class, (Object)"testedvarchar").forRow(row));
    }

    @Test
    public void testEncodeDate(TestContext ctx) {
        this.testPreparedQueryEncodeGeneric(ctx, "not_nullable_datatype", "test_date", LocalDate.of(1999, 12, 31), row -> ColumnChecker.checkColumn((int)0, (String)"test_date").returns(Tuple::getValue, Row::getValue, (Object)LocalDate.of(1999, 12, 31)).returns(Tuple::getLocalDate, Row::getLocalDate, (Object)LocalDate.of(1999, 12, 31)).returns(LocalDate.class, (Object)LocalDate.of(1999, 12, 31)).forRow(row));
    }

    @Test
    public void testEncodeTime(TestContext ctx) {
        this.testPreparedQueryEncodeGeneric(ctx, "not_nullable_datatype", "test_time", LocalTime.of(23, 10, 45), row -> ColumnChecker.checkColumn((int)0, (String)"test_time").returns(Tuple::getValue, Row::getValue, (Object)LocalTime.of(23, 10, 45)).returns(Tuple::getLocalTime, Row::getLocalTime, (Object)LocalTime.of(23, 10, 45)).returns(LocalTime.class, (Object)LocalTime.of(23, 10, 45)).forRow(row));
    }

    @Test
    public void testEncodeDateTime(TestContext ctx) {
        this.testPreparedQueryEncodeGeneric(ctx, "not_nullable_datatype", "test_datetime2", LocalDateTime.of(1999, 12, 31, 23, 10, 45), row -> ColumnChecker.checkColumn((int)0, (String)"test_datetime2").returns(Tuple::getValue, Row::getValue, (Object)LocalDateTime.of(1999, 12, 31, 23, 10, 45)).returns(Tuple::getLocalDateTime, Row::getLocalDateTime, (Object)LocalDateTime.of(1999, 12, 31, 23, 10, 45)).returns(Tuple::getLocalDate, Row::getLocalDate, (Object)LocalDate.of(1999, 12, 31)).returns(Tuple::getLocalTime, Row::getLocalTime, (Object)LocalTime.of(23, 10, 45)).returns(LocalDateTime.class, (Object)LocalDateTime.of(1999, 12, 31, 23, 10, 45)).forRow(row));
    }

    @Override
    protected void testDecodeValue(TestContext ctx, boolean isNull, String columnName, Consumer<Row> checker) {
        this.testPreparedQueryDecodeGeneric(ctx, "not_nullable_datatype", columnName, "1", checker);
    }

    private void testEncodeNumber(TestContext ctx, String columnName, Number value) {
        this.testPreparedQueryEncodeGeneric(ctx, "not_nullable_datatype", columnName, value, row -> MSSQLPreparedQueryNotNullableDataTypeTest.checkNumber(row, columnName, value));
    }
}

