/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.data;

import io.vertx.ext.unit.TestContext;
import io.vertx.mssqlclient.data.MSSQLDataTypeTestBase;
import io.vertx.sqlclient.ColumnChecker;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.data.Numeric;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.function.Consumer;
import org.junit.Test;

public abstract class MSSQLFullDataTypeTestBase
extends MSSQLDataTypeTestBase {
    @Test
    public void testDecodeAllColumns(TestContext ctx) {
        this.testDecodeNotNullValue(ctx, "*", row -> {
            ctx.assertEquals((Object)127, row.getValue("test_tinyint"));
            ctx.assertEquals((Object)Short.MAX_VALUE, row.getValue("test_smallint"));
            ctx.assertEquals((Object)Integer.MAX_VALUE, row.getValue("test_int"));
            ctx.assertEquals((Object)Long.MAX_VALUE, row.getValue("test_bigint"));
            ctx.assertEquals((Object)Float.valueOf(3.40282E38f), row.getValue("test_float_4"));
            ctx.assertEquals((Object)Double.MAX_VALUE, row.getValue("test_float_8"));
            ctx.assertEquals((Object)Numeric.create((Number)999.99), row.getValue("test_numeric"));
            ctx.assertEquals((Object)Numeric.create((Number)12345), row.getValue("test_decimal"));
            ctx.assertEquals((Object)true, row.getValue("test_boolean"));
            ctx.assertEquals((Object)"testchar", row.getValue("test_char"));
            ctx.assertEquals((Object)"testvarchar", row.getValue("test_varchar"));
            ctx.assertEquals((Object)LocalDate.of(2019, 1, 1), row.getValue("test_date"));
            ctx.assertEquals((Object)LocalTime.of(18, 45, 2), row.getValue("test_time"));
            ctx.assertEquals((Object)LocalDateTime.of(2019, 1, 1, 18, 45, 2), row.getValue("test_datetime2"));
        });
    }

    @Test
    public void testDecodeTinyInt(TestContext ctx) {
        this.testDecodeNotNullValue(ctx, "test_tinyint", row -> MSSQLFullDataTypeTestBase.checkNumber(row, "test_tinyint", (short)127));
    }

    @Test
    public void testDecodeSmallIntInt(TestContext ctx) {
        this.testDecodeNotNullValue(ctx, "test_smallint", row -> MSSQLFullDataTypeTestBase.checkNumber(row, "test_smallint", (short)Short.MAX_VALUE));
    }

    @Test
    public void testDecodeInt(TestContext ctx) {
        this.testDecodeNotNullValue(ctx, "test_int", row -> MSSQLFullDataTypeTestBase.checkNumber(row, "test_int", Integer.MAX_VALUE));
    }

    @Test
    public void testDecodeBigInt(TestContext ctx) {
        this.testDecodeNotNullValue(ctx, "test_bigint", row -> MSSQLFullDataTypeTestBase.checkNumber(row, "test_bigint", Long.MAX_VALUE));
    }

    @Test
    public void testDecodeFloat4(TestContext ctx) {
        this.testDecodeNotNullValue(ctx, "test_float_4", row -> MSSQLFullDataTypeTestBase.checkNumber(row, "test_float_4", Float.valueOf(3.40282E38f)));
    }

    @Test
    public void testDecodeFloat8(TestContext ctx) {
        this.testDecodeNotNullValue(ctx, "test_float_8", row -> MSSQLFullDataTypeTestBase.checkNumber(row, "test_float_8", Double.MAX_VALUE));
    }

    @Test
    public void testDecodeNumeric(TestContext ctx) {
        this.testDecodeNotNullValue(ctx, "test_numeric", row -> MSSQLFullDataTypeTestBase.checkNumber(row, "test_numeric", (Number)Numeric.create((Number)999.99)));
    }

    @Test
    public void testDecodeDecimal(TestContext ctx) {
        this.testDecodeNotNullValue(ctx, "test_decimal", row -> MSSQLFullDataTypeTestBase.checkNumber(row, "test_decimal", (Number)Numeric.create((Number)12345.0)));
    }

    @Test
    public void testDecodeBit(TestContext ctx) {
        this.testDecodeNotNullValue(ctx, "test_boolean", row -> ColumnChecker.checkColumn((int)0, (String)"test_boolean").returns(Tuple::getValue, Row::getValue, (Object)true).returns(Tuple::getBoolean, Row::getBoolean, (Object)true).returns(Boolean.class, (Object)true).forRow(row));
    }

    @Test
    public void testDecodeChar(TestContext ctx) {
        this.testDecodeNotNullValue(ctx, "test_char", row -> ColumnChecker.checkColumn((int)0, (String)"test_char").returns(Tuple::getValue, Row::getValue, (Object)"testchar").returns(Tuple::getString, Row::getString, (Object)"testchar").returns(String.class, (Object)"testchar").forRow(row));
    }

    @Test
    public void testDecodeVarChar(TestContext ctx) {
        this.testDecodeNotNullValue(ctx, "test_varchar", row -> ColumnChecker.checkColumn((int)0, (String)"test_varchar").returns(Tuple::getValue, Row::getValue, (Object)"testvarchar").returns(Tuple::getString, Row::getString, (Object)"testvarchar").returns(String.class, (Object)"testvarchar").forRow(row));
    }

    @Test
    public void testDecodeDate(TestContext ctx) {
        this.testDecodeNotNullValue(ctx, "test_date", row -> ColumnChecker.checkColumn((int)0, (String)"test_date").returns(Tuple::getValue, Row::getValue, (Object)LocalDate.of(2019, 1, 1)).returns(Tuple::getLocalDate, Row::getLocalDate, (Object)LocalDate.of(2019, 1, 1)).returns(LocalDate.class, (Object)LocalDate.of(2019, 1, 1)).forRow(row));
    }

    @Test
    public void testDecodeTime(TestContext ctx) {
        this.testDecodeNotNullValue(ctx, "test_time", row -> ColumnChecker.checkColumn((int)0, (String)"test_time").returns(Tuple::getValue, Row::getValue, (Object)LocalTime.of(18, 45, 2)).returns(Tuple::getLocalTime, Row::getLocalTime, (Object)LocalTime.of(18, 45, 2)).returns(LocalTime.class, (Object)LocalTime.of(18, 45, 2)).forRow(row));
    }

    @Test
    public void testDecodeDateTime(TestContext ctx) {
        this.testDecodeNotNullValue(ctx, "test_datetime2", row -> ColumnChecker.checkColumn((int)0, (String)"test_datetime2").returns(Tuple::getValue, Row::getValue, (Object)LocalDateTime.of(2019, 1, 1, 18, 45, 2)).returns(Tuple::getLocalDateTime, Row::getLocalDateTime, (Object)LocalDateTime.of(2019, 1, 1, 18, 45, 2)).returns(Tuple::getLocalDate, Row::getLocalDate, (Object)LocalDate.of(2019, 1, 1)).returns(Tuple::getLocalTime, Row::getLocalTime, (Object)LocalTime.of(18, 45, 2)).returns(LocalDateTime.class, (Object)LocalDateTime.of(2019, 1, 1, 18, 45, 2)).forRow(row));
    }

    protected abstract void testDecodeValue(TestContext var1, boolean var2, String var3, Consumer<Row> var4);

    private void testDecodeNotNullValue(TestContext ctx, String columnName, Consumer<Row> checker) {
        this.testDecodeValue(ctx, false, columnName, checker);
    }

    protected static void checkNumber(Row row, String columnName, Number value) {
        ColumnChecker.checkColumn((int)0, (String)columnName).returns(Tuple::getValue, Row::getValue, (Object)value).returns(Tuple::getShort, Row::getShort, (Object)value.shortValue()).returns(Tuple::getInteger, Row::getInteger, (Object)value.intValue()).returns(Tuple::getLong, Row::getLong, (Object)value.longValue()).returns(Tuple::getFloat, Row::getFloat, (Object)Float.valueOf(value.floatValue())).returns(Tuple::getDouble, Row::getDouble, (Object)value.doubleValue()).returns(Tuple::getBigDecimal, Row::getBigDecimal, (Object)new BigDecimal(value.toString())).returns(Byte.class, (Object)value.byteValue()).returns(Numeric.class, (Object)Numeric.create((Number)value)).forRow(row);
    }
}

