/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.mssqlclient.MSSQLConnectOptions;
import io.vertx.mssqlclient.MSSQLConnection;
import io.vertx.mssqlclient.MSSQLTestBase;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.SqlClient;
import java.util.HashMap;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class MSSQLConnectionTest
extends MSSQLTestBase {
    Vertx vertx;
    MSSQLConnectOptions options;

    @Before
    public void setup() {
        this.vertx = Vertx.vertx();
        this.options = new MSSQLConnectOptions(MSSQLTestBase.options);
    }

    @After
    public void tearDown(TestContext ctx) {
        this.vertx.close(ctx.asyncAssertSuccess());
    }

    @Test
    public void testConnectWithEmptyProperties(TestContext ctx) {
        this.options.setProperties(new HashMap());
        MSSQLConnection.connect((Vertx)this.vertx, (MSSQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(SqlClient::close));
    }

    @Test
    @Ignore(value="unsupported command")
    public void testInflightCommandsFailWhenConnectionClosed(TestContext ctx) {
        MSSQLConnection.connect((Vertx)this.vertx, (MSSQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn1 -> {
            conn1.query("WAITFOR DELAY '00:00:20'").execute(ctx.asyncAssertFailure(t -> ctx.assertEquals((Object)"Cannot continue the execution because the session is in the kill state.", (Object)t.getMessage())));
            MSSQLConnection.connect((Vertx)this.vertx, (MSSQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn2 -> conn2.preparedQuery("EXEC sp_who;").execute(ctx.asyncAssertSuccess(processRes -> {
                for (Row row : processRes) {
                    Short spid = row.getShort("spid");
                    String cmd = row.getString("cmd");
                    if (!cmd.contains("WAITFOR")) continue;
                    conn2.query(String.format("KILL %d", spid)).execute(ctx.asyncAssertSuccess(v -> conn2.close()));
                    break;
                }
            }))));
        }));
    }
}

