/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.spi;

import io.vertx.core.Vertx;
import io.vertx.mssqlclient.MSSQLConnectOptions;
import io.vertx.mssqlclient.MSSQLPool;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.spi.Driver;

public class MSSQLDriver
implements Driver {
    public Pool createPool(SqlConnectOptions options, PoolOptions poolOptions) {
        return MSSQLPool.pool(MSSQLDriver.wrap(options), poolOptions);
    }

    public Pool createPool(Vertx vertx, SqlConnectOptions options, PoolOptions poolOptions) {
        return MSSQLPool.pool(vertx, MSSQLDriver.wrap(options), poolOptions);
    }

    public boolean acceptsOptions(SqlConnectOptions options) {
        return options instanceof MSSQLConnectOptions || SqlConnectOptions.class.equals(options.getClass());
    }

    private static MSSQLConnectOptions wrap(SqlConnectOptions options) {
        if (options instanceof MSSQLConnectOptions) {
            return (MSSQLConnectOptions)options;
        }
        return new MSSQLConnectOptions(options);
    }
}

