/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.impl.protocol;

public enum MessageStatus {
    NORMAL(0),
    END_OF_MESSAGE(1),
    IGNORE_THIS_EVENT(2),
    RESET_CONNECTION(8),
    RESET_CONNECTION_SKIP_TRAN(16);

    private final int value;

    private MessageStatus(int value) {
        this.value = value;
    }

    public static MessageStatus valueOf(int value) {
        switch (value) {
            case 0: {
                return NORMAL;
            }
            case 1: {
                return END_OF_MESSAGE;
            }
            case 2: {
                return IGNORE_THIS_EVENT;
            }
            case 8: {
                return RESET_CONNECTION;
            }
            case 16: {
                return RESET_CONNECTION_SKIP_TRAN;
            }
        }
        throw new IllegalArgumentException("Unknown message status value");
    }

    public int value() {
        return this.value;
    }
}

