/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.vertx.mssqlclient.impl.protocol.MessageStatus;
import io.vertx.mssqlclient.impl.protocol.MessageType;
import io.vertx.mssqlclient.impl.protocol.TdsPacket;
import java.util.List;

class TdsPacketDecoder
extends ByteToMessageDecoder {
    TdsPacketDecoder() {
    }

    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf in, List<Object> list) throws Exception {
        if (in.readableBytes() > 8) {
            int packetStartIdx = in.readerIndex();
            int packetLen = in.getUnsignedShort(packetStartIdx + 2);
            if (in.readableBytes() >= packetLen) {
                MessageType type = MessageType.valueOf(in.readUnsignedByte());
                MessageStatus status = MessageStatus.valueOf(in.readUnsignedByte());
                in.skipBytes(2);
                int processId = in.readUnsignedShort();
                short packetId = in.readUnsignedByte();
                in.skipBytes(1);
                ByteBuf packetData = in.readRetainedSlice(packetLen - 8);
                list.add((Object)TdsPacket.newTdsPacket(type, status, packetLen, processId, packetId, packetData));
            }
        }
    }
}

