/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.impl.codec;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.vertx.mssqlclient.impl.codec.CloseConnectionCommandCodec;
import io.vertx.mssqlclient.impl.codec.ExtendedQueryCommandCodec;
import io.vertx.mssqlclient.impl.codec.InitCommandCodec;
import io.vertx.mssqlclient.impl.codec.MSSQLCommandCodec;
import io.vertx.mssqlclient.impl.codec.PreLoginCommandCodec;
import io.vertx.mssqlclient.impl.codec.PrepareStatementCodec;
import io.vertx.mssqlclient.impl.codec.SQLBatchCommandCodec;
import io.vertx.mssqlclient.impl.command.PreLoginCommand;
import io.vertx.sqlclient.impl.command.CloseConnectionCommand;
import io.vertx.sqlclient.impl.command.CommandBase;
import io.vertx.sqlclient.impl.command.ExtendedQueryCommand;
import io.vertx.sqlclient.impl.command.InitCommand;
import io.vertx.sqlclient.impl.command.PrepareStatementCommand;
import io.vertx.sqlclient.impl.command.SimpleQueryCommand;
import java.util.ArrayDeque;

class TdsMessageEncoder
extends ChannelOutboundHandlerAdapter {
    private final ArrayDeque<MSSQLCommandCodec<?, ?>> inflight;
    long transactionDescriptor;
    ChannelHandlerContext chctx;

    TdsMessageEncoder(ArrayDeque<MSSQLCommandCodec<?, ?>> inflight) {
        this.inflight = inflight;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.chctx = ctx;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof CommandBase) {
            CommandBase cmd = (CommandBase)msg;
            this.write(cmd);
        } else {
            super.write(ctx, msg, promise);
        }
    }

    void write(CommandBase<?> cmd) {
        MSSQLCommandCodec<?, ?> codec = this.wrap(cmd);
        codec.completionHandler = resp -> {
            MSSQLCommandCodec<?, ?> c = this.inflight.poll();
            resp.cmd = c.cmd;
            this.chctx.fireChannelRead(resp);
        };
        this.inflight.add(codec);
        codec.encode(this);
    }

    private MSSQLCommandCodec<?, ?> wrap(CommandBase<?> cmd) {
        if (cmd instanceof PreLoginCommand) {
            return new PreLoginCommandCodec((PreLoginCommand)cmd);
        }
        if (cmd instanceof InitCommand) {
            return new InitCommandCodec((InitCommand)cmd);
        }
        if (cmd instanceof SimpleQueryCommand) {
            return new SQLBatchCommandCodec((SimpleQueryCommand)cmd);
        }
        if (cmd instanceof PrepareStatementCommand) {
            return new PrepareStatementCodec((PrepareStatementCommand)cmd);
        }
        if (cmd instanceof ExtendedQueryCommand) {
            ExtendedQueryCommand queryCmd = (ExtendedQueryCommand)cmd;
            if (queryCmd.isBatch()) {
                throw new UnsupportedOperationException();
            }
            return new ExtendedQueryCommandCodec((ExtendedQueryCommand)cmd);
        }
        if (cmd == CloseConnectionCommand.INSTANCE) {
            return new CloseConnectionCommandCodec((CloseConnectionCommand)cmd);
        }
        throw new UnsupportedOperationException();
    }
}

