/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.vertx.mssqlclient.impl.codec.MSSQLCommandCodec;
import io.vertx.mssqlclient.impl.codec.TdsMessageEncoder;
import io.vertx.mssqlclient.impl.protocol.MessageStatus;
import io.vertx.mssqlclient.impl.protocol.TdsMessage;
import io.vertx.mssqlclient.impl.protocol.TdsPacket;
import java.util.ArrayDeque;
import java.util.List;

class TdsMessageDecoder
extends MessageToMessageDecoder<TdsPacket> {
    private final ArrayDeque<MSSQLCommandCodec<?, ?>> inflight;
    private final TdsMessageEncoder encoder;
    private TdsMessage message;

    TdsMessageDecoder(ArrayDeque<MSSQLCommandCodec<?, ?>> inflight, TdsMessageEncoder encoder) {
        this.inflight = inflight;
        this.encoder = encoder;
    }

    protected void decode(ChannelHandlerContext channelHandlerContext, TdsPacket tdsPacket, List<Object> list) throws Exception {
        if (tdsPacket.status() == MessageStatus.END_OF_MESSAGE) {
            if (this.message == null) {
                this.message = TdsMessage.newTdsMessageFromSinglePacket(tdsPacket);
                this.decodeMessage();
            } else {
                CompositeByteBuf messageData = (CompositeByteBuf)this.message.content();
                messageData.addComponent(true, tdsPacket.content());
                this.decodeMessage();
            }
        } else if (this.message == null) {
            CompositeByteBuf messageData = channelHandlerContext.alloc().compositeBuffer();
            messageData.addComponent(true, tdsPacket.content());
            this.message = TdsMessage.newTdsMessage(tdsPacket.type(), tdsPacket.status(), tdsPacket.processId(), (ByteBuf)messageData);
        } else {
            CompositeByteBuf messageData = (CompositeByteBuf)this.message.content();
            messageData.addComponent(true, tdsPacket.content());
        }
    }

    private void decodeMessage() {
        this.inflight.peek().decodeMessage(this.message, this.encoder);
        this.message = null;
    }
}

