/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.vertx.mssqlclient.impl.codec.ColumnData;
import io.vertx.mssqlclient.impl.codec.MSSQLCommandCodec;
import io.vertx.mssqlclient.impl.codec.MSSQLRowDesc;
import io.vertx.mssqlclient.impl.codec.RowResultDecoder;
import io.vertx.mssqlclient.impl.protocol.datatype.BitNDataType;
import io.vertx.mssqlclient.impl.protocol.datatype.FixedLenDataType;
import io.vertx.mssqlclient.impl.protocol.datatype.FloatNDataType;
import io.vertx.mssqlclient.impl.protocol.datatype.IntNDataType;
import io.vertx.mssqlclient.impl.protocol.datatype.MSSQLDataType;
import io.vertx.mssqlclient.impl.protocol.datatype.NumericDataType;
import io.vertx.mssqlclient.impl.protocol.datatype.TextWithCollationDataType;
import io.vertx.mssqlclient.impl.protocol.datatype.TimeNDataType;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.data.Numeric;
import io.vertx.sqlclient.impl.RowDesc;
import io.vertx.sqlclient.impl.command.QueryCommandBase;
import java.util.stream.Collector;

abstract class QueryCommandBaseCodec<T, C extends QueryCommandBase<T>>
extends MSSQLCommandCodec<Boolean, C> {
    protected RowResultDecoder<?, T> rowResultDecoder;

    QueryCommandBaseCodec(C cmd) {
        super(cmd);
    }

    private static <A, T> T emptyResult(Collector<Row, A, T> collector) {
        return collector.finisher().apply(collector.supplier().get());
    }

    protected void encodeTransactionDescriptor(ByteBuf payload) {
        payload.writeIntLE(18);
        payload.writeShortLE(2);
        payload.writeLongLE(this.encoder.transactionDescriptor);
        payload.writeIntLE(1);
    }

    protected MSSQLRowDesc decodeColmetadataToken(ByteBuf payload) {
        int columnCount = payload.readUnsignedShortLE();
        ColumnData[] columnDatas = new ColumnData[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            long userType = payload.readUnsignedIntLE();
            int flags = payload.readUnsignedShortLE();
            MSSQLDataType dataType = this.decodeDataTypeMetadata(payload);
            String columnName = this.readByteLenVarchar(payload);
            columnDatas[i] = new ColumnData(userType, flags, dataType, columnName);
        }
        return new MSSQLRowDesc(columnDatas);
    }

    protected void handleRow(ByteBuf payload) {
        this.rowResultDecoder.handleRow(this.rowResultDecoder.desc.columnDatas.length, payload);
    }

    protected void handleNbcRow(ByteBuf payload) {
        this.rowResultDecoder.handleNbcRow(this.rowResultDecoder.desc.columnDatas.length, payload);
    }

    protected void handleResultSetDone(int affectedRows) {
        int size;
        MSSQLRowDesc rowDesc;
        Object result;
        Throwable failure;
        this.result = false;
        if (this.rowResultDecoder != null) {
            failure = this.rowResultDecoder.complete();
            result = this.rowResultDecoder.result();
            rowDesc = this.rowResultDecoder.desc;
            size = this.rowResultDecoder.size();
            this.rowResultDecoder.reset();
        } else {
            result = QueryCommandBaseCodec.emptyResult(((QueryCommandBase)this.cmd).collector());
            failure = null;
            size = 0;
            rowDesc = null;
        }
        ((QueryCommandBase)this.cmd).resultHandler().handleResult(affectedRows, size, (RowDesc)rowDesc, result, failure);
    }

    private MSSQLDataType decodeDataTypeMetadata(ByteBuf payload) {
        short typeInfo = payload.readUnsignedByte();
        switch (typeInfo) {
            case 48: {
                return FixedLenDataType.INT1TYPE;
            }
            case 52: {
                return FixedLenDataType.INT2TYPE;
            }
            case 56: {
                return FixedLenDataType.INT4TYPE;
            }
            case 127: {
                return FixedLenDataType.INT8TYPE;
            }
            case 59: {
                return FixedLenDataType.FLT4TYPE;
            }
            case 62: {
                return FixedLenDataType.FLT8TYPE;
            }
            case 50: {
                return FixedLenDataType.BITTYPE;
            }
            case 106: 
            case 108: {
                short numericTypeSize = payload.readUnsignedByte();
                byte numericPrecision = payload.readByte();
                byte numericScale = payload.readByte();
                return new NumericDataType(108, Numeric.class, numericPrecision, numericScale);
            }
            case 38: {
                byte intNTypeLength = payload.readByte();
                return IntNDataType.valueOf(intNTypeLength);
            }
            case 109: {
                byte fltNTypeLength = payload.readByte();
                return FloatNDataType.valueOf(fltNTypeLength);
            }
            case 104: {
                payload.skipBytes(1);
                return BitNDataType.BIT_1_DATA_TYPE;
            }
            case 40: {
                return FixedLenDataType.DATENTYPE;
            }
            case 41: {
                byte scale = payload.readByte();
                return new TimeNDataType(scale);
            }
            case 167: 
            case 175: {
                int size = payload.readUnsignedShortLE();
                short collateCodepage = payload.readShortLE();
                short collateFlags = payload.readShortLE();
                byte collateCharsetId = payload.readByte();
                return new TextWithCollationDataType(167, (Class<?>)String.class, null);
            }
        }
        throw new UnsupportedOperationException("Unsupported type with typeinfo: " + typeInfo);
    }

    void handleEnvChangeToken(ByteBuf messageBody) {
        int totalLength = messageBody.readUnsignedShortLE();
        int startPos = messageBody.readerIndex();
        short type = messageBody.readUnsignedByte();
        switch (type) {
            case 8: 
            case 11: {
                if (messageBody.readUnsignedByte() != 8) {
                    throw new IllegalStateException();
                }
                this.encoder.transactionDescriptor = messageBody.readLongLE();
                break;
            }
            case 9: 
            case 10: 
            case 12: {
                this.encoder.transactionDescriptor = 0L;
                break;
            }
        }
        messageBody.readerIndex(startPos + totalLength);
    }
}

