/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.vertx.mssqlclient.impl.protocol.datatype.MSSQLDataType;
import io.vertx.mssqlclient.impl.protocol.datatype.NumericDataType;
import io.vertx.mssqlclient.impl.protocol.datatype.TimeNDataType;
import io.vertx.sqlclient.data.Numeric;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;

class MSSQLDataTypeCodec {
    static LocalDate START_DATE = LocalDate.of(1, 1, 1);
    private static Map<Class, String> parameterDefinitionsMapping = new HashMap<Class, String>();

    MSSQLDataTypeCodec() {
    }

    static String inferenceParamDefinitionByValueType(Object value) {
        if (value == null) {
            return "nvarchar(4000)";
        }
        if (value instanceof Numeric) {
            throw new UnsupportedOperationException();
        }
        if (value.getClass().isEnum()) {
            return parameterDefinitionsMapping.get(String.class);
        }
        String paramDefinition = parameterDefinitionsMapping.get(value.getClass());
        if (paramDefinition != null) {
            return paramDefinition;
        }
        throw new UnsupportedOperationException("Unsupported type" + value.getClass());
    }

    static Object decode(MSSQLDataType dataType, ByteBuf in) {
        switch (dataType.id()) {
            case 48: {
                return MSSQLDataTypeCodec.decodeTinyInt(in);
            }
            case 52: {
                return MSSQLDataTypeCodec.decodeSmallInt(in);
            }
            case 56: {
                return MSSQLDataTypeCodec.decodeInt(in);
            }
            case 127: {
                return MSSQLDataTypeCodec.decodeBigInt(in);
            }
            case 106: 
            case 108: {
                return MSSQLDataTypeCodec.decodeNumeric((NumericDataType)dataType, in);
            }
            case 38: {
                return MSSQLDataTypeCodec.decodeIntN(in);
            }
            case 59: {
                return Float.valueOf(MSSQLDataTypeCodec.decodeFloat4(in));
            }
            case 62: {
                return MSSQLDataTypeCodec.decodeFloat8(in);
            }
            case 109: {
                return MSSQLDataTypeCodec.decodeFltN(in);
            }
            case 50: {
                return MSSQLDataTypeCodec.decodeBit(in);
            }
            case 104: {
                return MSSQLDataTypeCodec.decodeBitN(in);
            }
            case 40: {
                return MSSQLDataTypeCodec.decodeDateN(in);
            }
            case 41: {
                return MSSQLDataTypeCodec.decodeTimeN((TimeNDataType)dataType, in);
            }
            case 167: {
                return MSSQLDataTypeCodec.decodeVarchar(in);
            }
        }
        throw new UnsupportedOperationException("Unsupported datatype: " + dataType);
    }

    private static LocalTime decodeTimeN(TimeNDataType dataType, ByteBuf in) {
        long timeValue;
        byte scale = dataType.scale();
        byte timeLength = in.readByte();
        switch (timeLength) {
            case 0: {
                return null;
            }
            case 3: {
                timeValue = in.readUnsignedMediumLE();
                break;
            }
            case 4: {
                timeValue = in.readUnsignedIntLE();
                break;
            }
            case 5: {
                timeValue = MSSQLDataTypeCodec.readUnsignedInt40LE(in);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected timeLength of [" + timeLength + "]");
            }
        }
        for (int i = 0; i < 7 - scale; ++i) {
            timeValue *= 10L;
        }
        timeValue = (long)((double)timeValue * Math.pow(10.0, 7 - scale));
        long secondsValue = timeValue / 100000000L;
        long nanosValue = timeValue % 100000000L;
        return LocalTime.ofSecondOfDay(secondsValue).plusNanos(nanosValue);
    }

    private static CharSequence decodeVarchar(ByteBuf in) {
        int length = in.readUnsignedShortLE();
        return in.readCharSequence(length, StandardCharsets.UTF_8);
    }

    private static LocalDate decodeDateN(ByteBuf in) {
        byte dateLength = in.readByte();
        if (dateLength == 0) {
            return null;
        }
        if (dateLength == 3) {
            int days = in.readUnsignedMediumLE();
            return START_DATE.plus(days, ChronoUnit.DAYS);
        }
        throw new IllegalStateException("Unexpected dateLength of [" + dateLength + "]");
    }

    private static boolean decodeBit(ByteBuf in) {
        return in.readBoolean();
    }

    private static double decodeFloat8(ByteBuf in) {
        return in.readDoubleLE();
    }

    private static float decodeFloat4(ByteBuf in) {
        return in.readFloatLE();
    }

    private static Numeric decodeNumeric(NumericDataType dataType, ByteBuf in) {
        Number value;
        int scale = dataType.scale();
        short length = in.readUnsignedByte();
        if (length == 0) {
            return null;
        }
        byte sign = in.readByte();
        switch (length - 1) {
            case 4: {
                value = in.readIntLE();
                break;
            }
            case 8: {
                value = in.readLongLE();
                break;
            }
            case 12: {
                return Numeric.create((Number)new BigDecimal(MSSQLDataTypeCodec.readUnsignedInt96LE(in), scale));
            }
            case 16: {
                return Numeric.create((Number)new BigDecimal(MSSQLDataTypeCodec.readUnsignedInt128LE(in), scale));
            }
            default: {
                throw new IllegalStateException("Unexpected numeric length of [" + length + "]");
            }
        }
        return Numeric.create((Number)((double)value.longValue() / Math.pow(10.0, scale) * (double)sign));
    }

    private static long decodeBigInt(ByteBuf in) {
        return in.readLongLE();
    }

    private static int decodeInt(ByteBuf in) {
        return in.readIntLE();
    }

    private static short decodeSmallInt(ByteBuf in) {
        return in.readShortLE();
    }

    private static short decodeTinyInt(ByteBuf in) {
        return in.readUnsignedByte();
    }

    private static long readUnsignedInt40LE(ByteBuf buffer) {
        return (long)buffer.readUnsignedByte() | (long)buffer.readUnsignedByte() << 8 | (long)buffer.readUnsignedByte() << 16 | (long)buffer.readUnsignedByte() << 24 | (long)buffer.readUnsignedByte() << 32;
    }

    private static BigInteger readUnsignedInt96LE(ByteBuf buffer) {
        byte[] result = new byte[12];
        int readerIndex = buffer.readerIndex();
        for (int i = 0; i < 12; ++i) {
            result[i] = buffer.getByte(readerIndex + 11 - i);
        }
        buffer.skipBytes(12);
        return new BigInteger(result);
    }

    private static BigInteger readUnsignedInt128LE(ByteBuf buffer) {
        byte[] result = new byte[16];
        int readerIndex = buffer.readerIndex();
        for (int i = 0; i < 16; ++i) {
            result[i] = buffer.getByte(readerIndex + 15 - i);
        }
        buffer.skipBytes(16);
        return new BigInteger(result);
    }

    private static Object decodeIntN(ByteBuf buffer) {
        byte intNDataTypeLength = buffer.readByte();
        switch (intNDataTypeLength) {
            case 0: {
                return null;
            }
            case 1: {
                return buffer.readUnsignedByte();
            }
            case 2: {
                return buffer.readShortLE();
            }
            case 4: {
                return buffer.readIntLE();
            }
            case 8: {
                return buffer.readLongLE();
            }
        }
        throw new UnsupportedOperationException(String.format("SEVERE: Unsupported length=[%d] for decoding IntNDataType row value.", intNDataTypeLength));
    }

    private static Object decodeFltN(ByteBuf buffer) {
        byte fltNDataTypeLength = buffer.readByte();
        switch (fltNDataTypeLength) {
            case 0: {
                return null;
            }
            case 4: {
                return Float.valueOf(buffer.readFloatLE());
            }
            case 8: {
                return buffer.readDoubleLE();
            }
        }
        throw new UnsupportedOperationException(String.format("SEVERE: Unsupported length=[%d] for decoding FLTNTYPE row value.", fltNDataTypeLength));
    }

    private static Object decodeBitN(ByteBuf buffer) {
        byte bitNDataTypeLength = buffer.readByte();
        switch (bitNDataTypeLength) {
            case 0: {
                return null;
            }
            case 1: {
                return buffer.readBoolean();
            }
        }
        throw new UnsupportedOperationException(String.format("SEVERE: Unsupported length=[%d] for decoding BITNTYPE row value.", bitNDataTypeLength));
    }

    static {
        parameterDefinitionsMapping.put(Byte.class, "tinyint");
        parameterDefinitionsMapping.put(Short.class, "smallint");
        parameterDefinitionsMapping.put(Integer.class, "int");
        parameterDefinitionsMapping.put(Long.class, "bigint");
        parameterDefinitionsMapping.put(Boolean.class, "bit");
        parameterDefinitionsMapping.put(Float.class, "float");
        parameterDefinitionsMapping.put(Double.class, "float");
        parameterDefinitionsMapping.put(String.class, "nvarchar(4000)");
        parameterDefinitionsMapping.put(LocalDate.class, "date");
        parameterDefinitionsMapping.put(LocalTime.class, "time");
    }
}

