/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.vertx.mssqlclient.impl.codec.MSSQLDataTypeCodec;
import io.vertx.mssqlclient.impl.codec.MSSQLRowDesc;
import io.vertx.mssqlclient.impl.codec.QueryCommandBaseCodec;
import io.vertx.mssqlclient.impl.codec.RowResultDecoder;
import io.vertx.mssqlclient.impl.codec.TdsMessageEncoder;
import io.vertx.mssqlclient.impl.protocol.MessageStatus;
import io.vertx.mssqlclient.impl.protocol.MessageType;
import io.vertx.mssqlclient.impl.protocol.TdsMessage;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.data.Numeric;
import io.vertx.sqlclient.impl.command.ExtendedQueryCommand;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;

class ExtendedQueryCommandCodec<T>
extends QueryCommandBaseCodec<T, ExtendedQueryCommand<T>> {
    ExtendedQueryCommandCodec(ExtendedQueryCommand cmd) {
        super(cmd);
    }

    @Override
    void encode(TdsMessageEncoder encoder) {
        super.encode(encoder);
        this.sendPrepexecRequest();
    }

    @Override
    void decodeMessage(TdsMessage message, TdsMessageEncoder encoder) {
        ByteBuf messageBody = message.content();
        block11: while (messageBody.isReadable()) {
            short tokenByte = messageBody.readUnsignedByte();
            switch (tokenByte) {
                case 129: {
                    MSSQLRowDesc rowDesc = this.decodeColmetadataToken(messageBody);
                    this.rowResultDecoder = new RowResultDecoder(((ExtendedQueryCommand)this.cmd).collector(), rowDesc);
                    continue block11;
                }
                case 209: {
                    this.handleRow(messageBody);
                    continue block11;
                }
                case 210: {
                    this.handleNbcRow(messageBody);
                    continue block11;
                }
                case 253: {
                    messageBody.skipBytes(12);
                    this.handleDoneToken();
                    continue block11;
                }
                case 171: {
                    int infoTokenLength = messageBody.readUnsignedShortLE();
                    messageBody.skipBytes(infoTokenLength);
                    continue block11;
                }
                case 170: {
                    this.handleErrorToken(messageBody);
                    continue block11;
                }
                case 255: {
                    short status = messageBody.readShortLE();
                    short curCmd = messageBody.readShortLE();
                    long doneRowCount = messageBody.readLongLE();
                    this.handleResultSetDone((int)doneRowCount);
                    this.handleDoneToken();
                    continue block11;
                }
                case 121: {
                    messageBody.skipBytes(4);
                    continue block11;
                }
                case 172: {
                    messageBody.skipBytes(messageBody.readableBytes());
                    continue block11;
                }
            }
            throw new UnsupportedOperationException("Unsupported token: " + tokenByte);
        }
    }

    private void sendPrepexecRequest() {
        ChannelHandlerContext chctx = this.encoder.chctx;
        ByteBuf packet = chctx.alloc().ioBuffer();
        packet.writeByte(MessageType.RPC.value());
        packet.writeByte(MessageStatus.NORMAL.value() | MessageStatus.END_OF_MESSAGE.value());
        int packetLenIdx = packet.writerIndex();
        packet.writeShort(0);
        packet.writeShort(0);
        packet.writeByte(0);
        packet.writeByte(0);
        int start = packet.writerIndex();
        packet.writeIntLE(0);
        this.encodeTransactionDescriptor(packet);
        packet.setIntLE(start, packet.writerIndex() - start);
        packet.writeShortLE(65535);
        packet.writeShortLE(13);
        packet.writeShortLE(0);
        packet.writeByte(0);
        packet.writeByte(1);
        packet.writeByte(38);
        packet.writeByte(4);
        packet.writeByte(4);
        packet.writeIntLE(0);
        Tuple params = ((ExtendedQueryCommand)this.cmd).params();
        String paramDefinitions = this.parseParamDefinitions(params);
        this.encodeNVarcharParameter(packet, paramDefinitions);
        this.encodeNVarcharParameter(packet, ((ExtendedQueryCommand)this.cmd).sql());
        for (int i = 0; i < params.size(); ++i) {
            this.encodeParamValue(packet, params.getValue(i));
        }
        int packetLen = packet.writerIndex() - packetLenIdx + 2;
        packet.setShort(packetLenIdx, packetLen);
        chctx.writeAndFlush((Object)packet);
    }

    private String parseParamDefinitions(Tuple params) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < params.size(); ++i) {
            Object param = params.getValue(i);
            stringBuilder.append("@P").append(i + 1).append(" ");
            stringBuilder.append(MSSQLDataTypeCodec.inferenceParamDefinitionByValueType(param));
            if (i == params.size() - 1) continue;
            stringBuilder.append(",");
        }
        return stringBuilder.toString();
    }

    private void encodeNVarcharParameter(ByteBuf payload, String value) {
        payload.writeByte(0);
        payload.writeByte(0);
        payload.writeByte(231);
        payload.writeShortLE(8000);
        payload.writeByte(9);
        payload.writeByte(4);
        payload.writeByte(208);
        payload.writeByte(0);
        payload.writeByte(52);
        this.writeUnsignedShortLenVarChar(payload, value);
    }

    private void encodeParamValue(ByteBuf payload, Object value) {
        if (value == null) {
            this.encodeNullParameter(payload);
        } else if (value instanceof Byte) {
            this.encodeIntNParameter(payload, 1, value);
        } else if (value instanceof Short) {
            this.encodeIntNParameter(payload, 2, value);
        } else if (value instanceof Integer) {
            this.encodeIntNParameter(payload, 4, value);
        } else if (value instanceof Long) {
            this.encodeIntNParameter(payload, 8, value);
        } else if (value instanceof Float) {
            this.encodeFloat4Parameter(payload, (Float)value);
        } else if (value instanceof Double) {
            this.encodeFloat8Parameter(payload, (Double)value);
        } else if (value instanceof String) {
            this.encodeNVarcharParameter(payload, (String)value);
        } else if (value instanceof Enum) {
            this.encodeNVarcharParameter(payload, ((Enum)value).name());
        } else if (value instanceof Boolean) {
            this.encodeBitNParameter(payload, (Boolean)value);
        } else if (value instanceof LocalDate) {
            this.encodeDateNParameter(payload, (LocalDate)value);
        } else if (value instanceof LocalTime) {
            this.encodeTimeNParameter(payload, (LocalTime)value, (byte)6);
        } else if (value instanceof Numeric) {
            this.encodeNumericParameter(payload, (Numeric)value);
        } else {
            throw new UnsupportedOperationException("Unsupported type");
        }
    }

    private void encodeNullParameter(ByteBuf payload) {
        payload.writeByte(0);
        payload.writeByte(0);
        payload.writeByte(31);
    }

    private void encodeIntNParameter(ByteBuf payload, int n, Object value) {
        payload.writeByte(0);
        payload.writeByte(0);
        payload.writeByte(38);
        payload.writeByte(n);
        payload.writeByte(n);
        switch (n) {
            case 1: {
                payload.writeByte((int)((Byte)value).byteValue());
                break;
            }
            case 2: {
                payload.writeShortLE((int)((Short)value).shortValue());
                break;
            }
            case 4: {
                payload.writeIntLE(((Integer)value).intValue());
                break;
            }
            case 8: {
                payload.writeLongLE(((Long)value).longValue());
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    private void encodeBitNParameter(ByteBuf payload, Boolean bit) {
        payload.writeByte(0);
        payload.writeByte(0);
        payload.writeByte(104);
        payload.writeByte(1);
        payload.writeByte(1);
        payload.writeBoolean(bit.booleanValue());
    }

    private void encodeFloat4Parameter(ByteBuf payload, Float value) {
        payload.writeByte(0);
        payload.writeByte(0);
        payload.writeByte(109);
        payload.writeByte(4);
        payload.writeByte(4);
        payload.writeFloatLE(value.floatValue());
    }

    private void encodeFloat8Parameter(ByteBuf payload, Double value) {
        payload.writeByte(0);
        payload.writeByte(0);
        payload.writeByte(109);
        payload.writeByte(8);
        payload.writeByte(8);
        payload.writeDoubleLE(value.doubleValue());
    }

    private void encodeDateNParameter(ByteBuf payload, LocalDate date) {
        payload.writeByte(0);
        payload.writeByte(0);
        payload.writeByte(40);
        if (date == null) {
            payload.writeByte(0);
        } else {
            payload.writeByte(3);
            long days = ChronoUnit.DAYS.between(MSSQLDataTypeCodec.START_DATE, date);
            payload.writeMediumLE((int)days);
        }
    }

    private void encodeTimeNParameter(ByteBuf payload, LocalTime time, byte scale) {
        payload.writeByte(0);
        payload.writeByte(0);
        payload.writeByte(41);
        payload.writeByte((int)scale);
        if (time == null) {
            payload.writeByte(0);
        } else {
            int length = scale <= 2 ? 3 : (scale <= 4 ? 4 : 5);
            payload.writeByte(length);
            long nanos = time.getNano();
            int seconds = time.toSecondOfDay();
            long value = (long)((double)seconds * Math.pow(10.0, scale) + (double)nanos);
            this.encodeInt40(payload, value);
        }
    }

    private void encodeInt40(ByteBuf buffer, long value) {
        int index = buffer.writerIndex();
        buffer.setByte(index, (int)((byte)value));
        buffer.setByte(index + 1, (int)((byte)(value >>> 8)));
        buffer.setByte(index + 2, (int)((byte)(value >>> 16)));
        buffer.setByte(index + 3, (int)((byte)(value >>> 24)));
        buffer.setByte(index + 4, (int)((byte)(value >>> 32)));
        buffer.writerIndex(index + 5);
    }

    private void encodeNumericParameter(ByteBuf buffer, Numeric value) {
        throw new UnsupportedOperationException();
    }
}

