/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.impl;

import io.netty.channel.ChannelPipeline;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.net.impl.NetSocketInternal;
import io.vertx.mssqlclient.impl.MSSQLDatabaseMetadata;
import io.vertx.mssqlclient.impl.codec.MSSQLCodec;
import io.vertx.mssqlclient.impl.command.PreLoginCommand;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.QueryResultHandler;
import io.vertx.sqlclient.impl.SocketConnectionBase;
import io.vertx.sqlclient.impl.command.CommandBase;
import io.vertx.sqlclient.impl.command.InitCommand;
import io.vertx.sqlclient.impl.command.QueryCommandBase;
import io.vertx.sqlclient.impl.command.SimpleQueryCommand;
import io.vertx.sqlclient.impl.command.TxCommand;
import io.vertx.sqlclient.spi.DatabaseMetadata;
import java.util.Map;
import java.util.function.Predicate;

class MSSQLSocketConnection
extends SocketConnectionBase {
    public MSSQLDatabaseMetadata dbMetaData;

    MSSQLSocketConnection(NetSocketInternal socket, boolean cachePreparedStatements, int preparedStatementCacheSize, Predicate<String> preparedStatementCacheSqlFilter, int pipeliningLimit, ContextInternal context) {
        super(socket, cachePreparedStatements, preparedStatementCacheSize, preparedStatementCacheSqlFilter, pipeliningLimit, context);
    }

    void sendPreLoginMessage(boolean ssl, Handler<AsyncResult<Void>> completionHandler) {
        PreLoginCommand cmd = new PreLoginCommand(ssl);
        Promise promise = Promise.promise();
        promise.future().onComplete(completionHandler);
        this.schedule(cmd, promise);
    }

    void sendLoginMessage(String username, String password, String database, Map<String, String> properties, Handler<AsyncResult<Connection>> completionHandler) {
        InitCommand cmd = new InitCommand((SocketConnectionBase)this, username, password, database, properties);
        Promise promise = Promise.promise();
        promise.future().onComplete(completionHandler);
        this.schedule((CommandBase)cmd, promise);
    }

    public void init() {
        ChannelPipeline pipeline = this.socket.channelHandlerContext().pipeline();
        MSSQLCodec.initPipeLine(pipeline);
        super.init();
    }

    protected <R> void doSchedule(CommandBase<R> cmd, Handler<AsyncResult<R>> handler) {
        if (cmd instanceof TxCommand) {
            TxCommand tx = (TxCommand)cmd;
            String sql = tx.kind == TxCommand.Kind.BEGIN ? "BEGIN TRANSACTION" : tx.kind.sql;
            SimpleQueryCommand cmd2 = new SimpleQueryCommand(sql, false, false, QueryCommandBase.NULL_COLLECTOR, QueryResultHandler.NOOP_HANDLER);
            super.doSchedule((CommandBase)cmd2, ar -> handler.handle((Object)ar.map(tx.result)));
        } else {
            super.doSchedule(cmd, handler);
        }
    }

    public DatabaseMetadata getDatabaseMetaData() {
        return this.dbMetaData;
    }
}

