/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.impl;

import io.vertx.core.buffer.Buffer;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.data.Numeric;
import io.vertx.sqlclient.impl.ArrayTuple;
import io.vertx.sqlclient.impl.RowDesc;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.temporal.Temporal;
import java.util.List;
import java.util.UUID;

public class MSSQLRowImpl
extends ArrayTuple
implements Row {
    private final RowDesc rowDesc;

    public MSSQLRowImpl(RowDesc rowDesc) {
        super(rowDesc.columnNames().size());
        this.rowDesc = rowDesc;
    }

    public String getColumnName(int pos) {
        List columnNames = this.rowDesc.columnNames();
        return pos < 0 || columnNames.size() - 1 < pos ? null : (String)columnNames.get(pos);
    }

    public int getColumnIndex(String column) {
        if (column == null) {
            throw new IllegalArgumentException("Column name can not be null");
        }
        return this.rowDesc.columnNames().indexOf(column);
    }

    public <T> T get(Class<T> type, int position) {
        if (type == Boolean.class) {
            return type.cast(this.getBoolean(position));
        }
        if (type == Byte.class) {
            return type.cast(this.getByte(position));
        }
        if (type == Short.class) {
            return type.cast(this.getShort(position));
        }
        if (type == Integer.class) {
            return type.cast(this.getInteger(position));
        }
        if (type == Long.class) {
            return type.cast(this.getLong(position));
        }
        if (type == Float.class) {
            return type.cast(this.getFloat(position));
        }
        if (type == Double.class) {
            return type.cast(this.getDouble(position));
        }
        if (type == Numeric.class) {
            return type.cast(this.getNumeric(position));
        }
        if (type == String.class) {
            return type.cast(this.getString(position));
        }
        if (type == LocalDate.class) {
            return type.cast(this.getLocalDate(position));
        }
        if (type == LocalTime.class) {
            return type.cast(this.getLocalTime(position));
        }
        if (type == Object.class) {
            return type.cast(this.getValue(position));
        }
        if (type.isEnum()) {
            return type.cast(this.getEnum(type, position));
        }
        throw new UnsupportedOperationException("Unsupported type " + type.getName());
    }

    public Buffer getBuffer(int pos) {
        throw new UnsupportedOperationException();
    }

    public Temporal getTemporal(int pos) {
        throw new UnsupportedOperationException();
    }

    public LocalDateTime getLocalDateTime(int pos) {
        throw new UnsupportedOperationException();
    }

    public OffsetTime getOffsetTime(int pos) {
        throw new UnsupportedOperationException();
    }

    public OffsetDateTime getOffsetDateTime(int pos) {
        throw new UnsupportedOperationException();
    }

    public UUID getUUID(int pos) {
        throw new UnsupportedOperationException();
    }

    public Integer[] getIntegerArray(int pos) {
        throw new UnsupportedOperationException();
    }

    public Boolean[] getBooleanArray(int pos) {
        throw new UnsupportedOperationException();
    }

    public Short[] getShortArray(int pos) {
        throw new UnsupportedOperationException();
    }

    public Long[] getLongArray(int pos) {
        throw new UnsupportedOperationException();
    }

    public Float[] getFloatArray(int pos) {
        throw new UnsupportedOperationException();
    }

    public Double[] getDoubleArray(int pos) {
        throw new UnsupportedOperationException();
    }

    public Numeric[] getNumericArray(String column) {
        throw new UnsupportedOperationException();
    }

    public String[] getStringArray(int pos) {
        throw new UnsupportedOperationException();
    }

    public LocalDate[] getLocalDateArray(int pos) {
        throw new UnsupportedOperationException();
    }

    public LocalTime[] getLocalTimeArray(int pos) {
        throw new UnsupportedOperationException();
    }

    public OffsetTime[] getOffsetTimeArray(int pos) {
        throw new UnsupportedOperationException();
    }

    public LocalDateTime[] getLocalDateTimeArray(int pos) {
        throw new UnsupportedOperationException();
    }

    public OffsetDateTime[] getOffsetDateTimeArray(int pos) {
        throw new UnsupportedOperationException();
    }

    public Buffer[] getBufferArray(int pos) {
        throw new UnsupportedOperationException();
    }

    public UUID[] getUUIDArray(int pos) {
        throw new UnsupportedOperationException();
    }

    private Byte getByte(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof Byte) {
            return (Byte)val;
        }
        if (val instanceof Number) {
            return ((Number)val).byteValue();
        }
        return null;
    }

    private Object getEnum(Class enumType, int position) {
        T[] constants;
        int ordinal;
        Object val = this.getValue(position);
        if (val instanceof String) {
            return Enum.valueOf(enumType, (String)val);
        }
        if (val instanceof Number && (ordinal = ((Number)val).intValue()) >= 0 && ordinal < (constants = enumType.getEnumConstants()).length) {
            return constants[ordinal];
        }
        return null;
    }
}

