/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.Handler;
import io.vertx.core.impl.CloseFuture;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.mssqlclient.MSSQLConnectOptions;
import io.vertx.mssqlclient.MSSQLPool;
import io.vertx.mssqlclient.impl.MSSQLConnectionFactory;
import io.vertx.mssqlclient.impl.MSSQLConnectionImpl;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.ConnectionFactory;
import io.vertx.sqlclient.impl.PoolBase;
import io.vertx.sqlclient.impl.SqlConnectionImpl;
import io.vertx.sqlclient.impl.tracing.QueryTracer;

public class MSSQLPoolImpl
extends PoolBase<MSSQLPoolImpl>
implements MSSQLPool {
    private final MSSQLConnectionFactory connectionFactory;

    public static MSSQLPoolImpl create(ContextInternal context, boolean closeVertx, MSSQLConnectOptions connectOptions, PoolOptions poolOptions) {
        QueryTracer tracer = context.tracer() == null ? null : new QueryTracer(context.tracer(), (SqlConnectOptions)connectOptions);
        VertxMetrics vertxMetrics = context.owner().metricsSPI();
        ClientMetrics metrics = vertxMetrics != null ? vertxMetrics.createClientMetrics(connectOptions.getSocketAddress(), "sql", connectOptions.getMetricsName()) : null;
        MSSQLPoolImpl pool = new MSSQLPoolImpl(context, new MSSQLConnectionFactory(context, connectOptions), tracer, metrics, poolOptions);
        CloseFuture closeFuture = pool.closeFuture();
        if (closeVertx) {
            closeFuture.onComplete(ar -> context.owner().close());
        } else {
            context.addCloseHook((Closeable)closeFuture);
        }
        return pool;
    }

    private MSSQLPoolImpl(ContextInternal context, MSSQLConnectionFactory factory, QueryTracer tracer, ClientMetrics metrics, PoolOptions poolOptions) {
        super(context, (ConnectionFactory)factory, tracer, metrics, poolOptions);
        this.connectionFactory = factory;
    }

    public int appendQueryPlaceholder(StringBuilder queryBuilder, int index, int current) {
        queryBuilder.append('@').append('P').append(1 + index);
        return index;
    }

    public void connect(Handler<AsyncResult<Connection>> completionHandler) {
        this.connectionFactory.connect().onComplete(completionHandler);
    }

    protected SqlConnectionImpl wrap(ContextInternal context, Connection connection) {
        return new MSSQLConnectionImpl(this.connectionFactory, context, connection, this.tracer, this.metrics);
    }
}

